/* $Id: SpreadSelectPopupMenu.java 681 2013-03-17 16:20:21Z shayashi $ */
package smart_gs.swingui;

import java.util.List;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import smart_gs.drawing_tool.action.SheetSelectAction;
import smart_gs.logical.GSResource;
import smart_gs.logical.Sheet;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.SpreadTree;
import smart_gs.swingui.toolbar.action.NewCompactEditorAction;
import smart_gs.swingui.toolbar.action.NewEditorAction;
import smart_gs.swingui.tree.action.MakeNewSpreadDirectoryAction;
import smart_gs.swingui.tree.action.AddSpreadDirectoryAction;
import smart_gs.swingui.tree.action.AddSpreadsAction;
import smart_gs.swingui.tree.action.ImportImagesAction;
import smart_gs.swingui.tree.action.DeleteSelectedSpreadTreeItemsAction;
import smart_gs.swingui.tree.action.SortSelectedSpreadTreeItemsByNameAction;

// 2011.03.14 shayashi changed
public class SpreadSelectPopupMenu extends JPopupMenu {
	private JMenuItem setSheetNameItem;
	private JMenuItem showSheetItem;
	private static boolean inUse = false;
	
	public static void free() {inUse = false;}
	public static void lock() {inUse = true;}
	
	public SpreadSelectPopupMenu(SpreadTree tree){
		if (inUse) return;

		TreePath[] paths = tree.getSelectionPaths();
		int size;
		if (paths != null) size = paths.length; else return;

		if(size == 0){
			// Nothing selected
			JOptionPane.showMessageDialog(null, "Select items in ImageTree");
		}else if (size == 1){
			// Single item selected
			DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
			GSResource selectedItem = (GSResource)selectedNode.getUserObject();
			// SpreadDirectory Operations
			if (selectedItem instanceof SpreadDirectory){
				SpreadDirectory spreadDirectory = (SpreadDirectory)selectedItem;
				// Import 
				JMenuItem copyAndAddItem = new JMenuItem("Import Images");
				copyAndAddItem.addActionListener(new ImportImagesAction(selectedNode,tree));
				this.add(copyAndAddItem);
				// making a child SpreadDirectory
				JMenuItem makeDirectory = new JMenuItem("Make New Directory");
				makeDirectory.addActionListener(new MakeNewSpreadDirectoryAction(selectedNode,tree));
				this.add(makeDirectory);
				// deletion 
				JMenuItem deleteItem = new JMenuItem("Delete Selected Directory");
				deleteItem.addActionListener(new DeleteSelectedSpreadTreeItemsAction(tree));
				this.add(deleteItem);
				// Image Folder Operations
				JMenu imageFolderOperationMenu = new JMenu("Image Folder Operations:"); 
				this.add(imageFolderOperationMenu);
				{
					JMenuItem addItem = new JMenuItem("Add Images to ImageTree");
					addItem.addActionListener(new AddSpreadsAction(spreadDirectory.getFile(),tree,spreadDirectory));
					imageFolderOperationMenu.add(addItem);
					JMenuItem addDirectory = new JMenuItem("Add Directory and Ancestors to ImageTree");
					addDirectory.addActionListener(new AddSpreadDirectoryAction(spreadDirectory.getFile(),spreadDirectory));
					imageFolderOperationMenu.add(addDirectory);
				}
			} else {
			// Spread Operations
				JMenuItem deleteItem = new JMenuItem("Delete Image");
				deleteItem.addActionListener(new DeleteSelectedSpreadTreeItemsAction(tree));
				this.add(deleteItem);
				JMenuItem openItemInEditor = new JMenuItem("Open in Editor");
				openItemInEditor.addActionListener(new NewEditorAction());
				this.add(openItemInEditor);
				JMenuItem openItemInCompactEditor = new JMenuItem("Open in Compact Editor");
				openItemInCompactEditor.addActionListener(new NewCompactEditorAction());
				this.add(openItemInCompactEditor);
			}
		} else {
			// Multiple items selected
			JMenuItem deleteItem = new JMenuItem("Delete Selected Items");
			deleteItem.addActionListener(new DeleteSelectedSpreadTreeItemsAction(tree));
			this.add(deleteItem);
			JMenuItem sortItemByName = new JMenuItem("Sort Selected Items by Name");
			sortItemByName.addActionListener(new SortSelectedSpreadTreeItemsByNameAction(tree));
			this.add(sortItemByName);
		}
	}
}
