/* $Id: UsersNoteSelectPopupMenu.java 132 2011-03-29 01:35:19Z shayashi $ */
package smart_gs.swingui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import smart_gs.drawing_tool.action.SheetSelectAction;
import smart_gs.logical.UsersNoteTree;
import smart_gs.logical.GSResource;
import smart_gs.logical.Sheet;
import smart_gs.logical.UsersNote;
import smart_gs.logical.UsersNoteDirectory;
import smart_gs.swingui.tree.action.DeleteSelectedUsersNoteTreeItemsAction;
import smart_gs.swingui.tree.action.MakeUsersNoteAction;
import smart_gs.swingui.tree.action.MakeUsersNoteDirectoryAction;
import smart_gs.swingui.tree.action.ImportImagesAction;
import smart_gs.swingui.tree.action.DeleteSelectedUsersNoteTreeItemsAction;
import smart_gs.swingui.tree.action.MakeUsersNoteDirectoryAction;
import smart_gs.swingui.tree.action.SortSelectedUsersNoteTreeItemsByNameAction;
import smart_gs.swingui.tree.action.UsersNoteNodeChangeNameAction;


// 2011.03.14 shayashi changed
public class UsersNoteTreeSelectPopupMenu extends JPopupMenu {
	private JMenuItem setSheetNameItem;
	private JMenuItem showSheetItem;
	
	public UsersNoteTreeSelectPopupMenu(UsersNoteTree tree){
//	2011.03.15 shayashi
//		changed much including the name of class.
		TreePath[] paths = tree.getSelectionPaths();
		int size;
		if (paths != null) size = paths.length; else return;

		if(size == 0){
			// Nothing selected
			JOptionPane.showMessageDialog(WorkspaceWindow.getInstance(), "Select items in ImageTree");
		}else if (size == 1){
			// Single item selected
			DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
//			System.out.printf("%s\n",selectedNode);
			//2011/05/24 kukita changed
			GSResource selectedItem = (GSResource)selectedNode.getUserObject();
			// UsersNoteDirectory Operations
		
			if (selectedItem instanceof UsersNoteDirectory){
				UsersNoteDirectory usersNoteDirectory = (UsersNoteDirectory)selectedItem;
				// Change name
				JMenuItem changeName = new JMenuItem("Change Name");
				changeName.addActionListener(new UsersNoteNodeChangeNameAction(selectedNode,tree));
				this.add(changeName);
				// Make new text 
				JMenuItem makeNewText = new JMenuItem("Make New Text");
				makeNewText.addActionListener(new MakeUsersNoteAction(selectedNode,tree));
				this.add(makeNewText);
				// making a child UsersNoteDirectory
				JMenuItem makeDirectory = new JMenuItem("Make New Directory");
				makeDirectory.addActionListener(new MakeUsersNoteDirectoryAction(selectedNode,tree));
				this.add(makeDirectory);
				// deletion 
				JMenuItem deleteItem = new JMenuItem("Delete Selected Directory");
				deleteItem.addActionListener(new DeleteSelectedUsersNoteTreeItemsAction(tree));
				this.add(deleteItem);
			} else {
			// UsersNote Operations
				// Change name
				JMenuItem changeName = new JMenuItem("Change Name");
				changeName.addActionListener(new UsersNoteNodeChangeNameAction(selectedNode,tree));
				this.add(changeName);
				JMenuItem deleteItem = new JMenuItem("Delete Selected Note");
				deleteItem.addActionListener(new DeleteSelectedUsersNoteTreeItemsAction(tree));
				this.add(deleteItem);
			}
		} else {
			// Multiple items selected
			JMenuItem deleteItem = new JMenuItem("Delete Selected Items");
			deleteItem.addActionListener(new DeleteSelectedUsersNoteTreeItemsAction(tree));
			this.add(deleteItem);
			JMenuItem sortItemByName = new JMenuItem("Sort Selected Items by Name");
			sortItemByName.addActionListener(new SortSelectedUsersNoteTreeItemsByNameAction(tree));
			this.add(sortItemByName);
		}
	}
}
