/* $Id: UtilityToolBar.java 664 2013-02-14 12:09:43Z ohura $ */
package smart_gs.swingui.toolbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

import smart_gs.GSConstants;
import smart_gs.debugprint.Debugprint;
import smart_gs.logical.Preference;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.toolbar.action.LineSegEditorActionListener;
import smart_gs.swingui.toolbar.action.ShowLinesActionListener;

@SuppressWarnings("serial")
public class UtilityToolBar extends JToolBar implements ActionListener{
	GSEditor editor = null;
	JButton displayTyepAndModeButton;
	private Icon displayTyepAndModeButtonIcon = null;
	private Icon compactIcon = null;
	private Icon leftIcon = null;
	private Icon topIcon = null;
	private Icon rightIcon = null;
	private Icon bottomIcon = null;
	
	public UtilityToolBar(AbstractGSWindow parent, boolean isInWorkspaceWindow) {		
		JButton linesegshow = new JButton(new ImageIcon(GSConstants.ICON_PATH+"linesegment.png"));
		linesegshow.addActionListener(new ShowLinesActionListener(parent));
		linesegshow.setToolTipText("Line Segment Display Mode");
		this.add(linesegshow);
		
		if (isInWorkspaceWindow) {
			JButton linesegeditor = new JButton(new ImageIcon(GSConstants.ICON_PATH+"linesegmentediting2.png"));
			linesegeditor.addActionListener(new LineSegEditorActionListener(parent));
			if(Preference.getInstance().isEnabledLineSegmentEditor()){
				linesegeditor.setToolTipText("Open Line Segment Editor");
			} else {
				linesegeditor.setToolTipText("Open Line Segment Editor (disabled)");
				linesegeditor.setEnabled(false);
			}
			this.add(linesegeditor);
		}

		JButton rw = new JButton(new ImageIcon(GSConstants.ICON_PATH+"reasoningweb.png"));
		rw.addActionListener(this);
		rw.setToolTipText("Open Resioning Web");
		this.add(rw);

		if (! isInWorkspaceWindow) {
			this.editor = (GSEditor)parent;
			this.displayTyepAndModeButton = new JButton(getGSEditorTypeAndDisplayModeIcon());		
			this.displayTyepAndModeButton.addActionListener(new GSEditorTypeAndModeButtonActionListener(editor));
			this.displayTyepAndModeButton.setToolTipText("Change editor type (click) and image pane position (alt + click)");
			this.add(this.displayTyepAndModeButton);
		}
	}
	
	public Icon getGSEditorTypeAndDisplayModeIcon() {
		int type = this.editor.getEditorType();
		int mode = this.editor.getDisplayMode();

		if (this.displayTyepAndModeButtonIcon == null ) {
			if (type == GSEditor.FULL) {
				this.displayTyepAndModeButtonIcon = this.getGSEditorTypeAndDisplayModeIconToCompactIcon();
			} else {
				this.displayTyepAndModeButtonIcon = getGSEditorFullTypeAndDisplayModeIcon(mode);
			}			
		}
		return this.displayTyepAndModeButtonIcon;
	}
	
	private Icon getGSEditorTypeAndDisplayModeIconToCompactIcon() {
		if (this.compactIcon == null) {
			this.compactIcon = new ImageIcon(GSConstants.ICON_PATH+"compact.png");
		}
		return this.compactIcon;
	}
	
	private Icon getGSEditorFullTypeAndDisplayModeIcon(int mode) {
		switch (mode) {
		case GSConstants.WINDOW_HORIZONTAL_IMAGE_LEFT_MODE :
			if (this.leftIcon == null) {
				this.leftIcon = new ImageIcon(GSConstants.ICON_PATH+"left.png");
			}	
			return this.leftIcon;
		case GSConstants.WINDOW_VERTICAL_IMAGE_TOP_MODE:
			if (this.topIcon == null) {
				this.topIcon = new ImageIcon(GSConstants.ICON_PATH+"top.png");
			}
			return this.topIcon;
		case GSConstants.WINDOW_HORIZONTAL_IMAGE_RIGHT_MODE:
			if (this.rightIcon == null) {
				this.rightIcon = new ImageIcon(GSConstants.ICON_PATH+"right.png");
			}
			return this.rightIcon;
		case GSConstants.WINDOW_VERTICAL_IMAGE_BOTTOM_MODE:
			if (this.bottomIcon == null) {
				this.bottomIcon = new ImageIcon(GSConstants.ICON_PATH+"bottom.png");
			}
			return this.bottomIcon;
		default:
			if (this.leftIcon == null) {
				this.leftIcon = new ImageIcon(GSConstants.ICON_PATH+"left.png");
			}
			return this.leftIcon;
		}
	}
	
	public void updateGSEditorTypeAndDisplayModeIcon() {
		this.displayTyepAndModeButton.setIcon(this.displayTyepAndModeButtonIcon);
		validate();
		repaint();
	}
	
	public void actionPerformed(ActionEvent e) {
		ReasoningWebFrame.getInstance().setVisible(true);
	}


	public void setGSEditorTypeAndDisplayModeIconToCompactEditorIcon() {
		this.displayTyepAndModeButtonIcon = getGSEditorTypeAndDisplayModeIconToCompactIcon();
		this.displayTyepAndModeButton.setIcon(getGSEditorTypeAndDisplayModeIcon());		
	}

	public void setGSEditorTypeAndDisplayModeIconToFullEditorIcon() {
		int mode = editor.getDisplayMode();
		this.displayTyepAndModeButtonIcon = getGSEditorFullTypeAndDisplayModeIcon(mode);
		this.displayTyepAndModeButton.setIcon(getGSEditorTypeAndDisplayModeIcon());	
	}
	
	public void setGSEditorTypeAndDisplayModeIconToNextFullEditorIcon() {
		int mode = editor.getDisplayMode();
		this.displayTyepAndModeButtonIcon = getGSEditorFullTypeAndDisplayModeIcon((mode + 1)%4);
		this.displayTyepAndModeButton.setIcon(getGSEditorTypeAndDisplayModeIcon());	
	}
}
