/*
ファイルのコピーを行う。
w_funcの内容はcopybench-1.0（New BSD License）を参考にした
*/

#define _GNU_SOURCE

#include "global.h"
#include "struct.h"
#include "enum.h"

#include "snowcp.h"
#include "ch_time_mod.h"
#include "compare.h"
#include "hash_function.h"
#include "log.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <pthread.h>

struct fd_buf_num
{
	int ifrom;
	int ito;
	int read_buf_num;
	int write_buf_num;
	long long from_size;
	long long write_size;
};

static void *buf[2];
static int buffer_size_local;
volatile static long long next_write_size[2];
volatile static long long total_read_local = 0;
volatile static long long total_write_local = 0;

volatile long long total_read = 0;
volatile long long total_write = 0;

// 関数プロトタイプ
void rw_thread(struct cp_target *cp_tmp);
static void * r_func(void *read_t);
static void * w_func(void *write_t);

/*******************************************************************************

*******************************************************************************/
void rw_thread(struct cp_target *cp_tmp)
{
	pthread_t t1;
	pthread_t t2;
	struct stat stat_buf;
	struct fd_buf_num rw;
	errno = 0;

	if((rw.ifrom = open(cp_tmp->from, O_RDONLY | O_NOATIME)) == -1)
	{
		log_errors(__FILE__, __LINE__, errno, cp_tmp->from);
		errno = 0;
	}
	// 何か普通に戻り値が-1。
	// O_TRUNCしていないので注意。
	if((rw.ito = open(cp_tmp->to, O_CREAT | O_WRONLY, S_IRUSR | S_IWUSR)) == -1);
	{
		/*
		何でerrno 17とか22とかが出るんだ？

		解決。errno = 0し忘れてた。
		*/
		if(errno > 0)
		{
			log_errors(__FILE__, __LINE__, errno, cp_tmp->to);
		}
	}

	// signalハンドラ用
	write_now = cp_tmp->to;

	// open出来たらこのチェックは要らない気がする
	if(fstat(rw.ifrom, &stat_buf) == -1)
	{
		log_errors(__FILE__, __LINE__, errno, cp_tmp->from);
		rw.from_size = -1;
	}
	else
	{
		rw.from_size = stat_buf.st_size;
		/*
		コピー前にファイルをトランケート。いわゆるsparse file化。
		Windowsだと断片化防止に効果があるのだが、Linuxだと？

		1.2TBほどコピーしてみたあと、fsckを実行したら、
		non-contiguousは3.2%だった。効果無し？
		*/
		//if(ftruncate(rw.ito, stat_buf.st_size) == -1)
			//log_errors(cp_tmp->to, "ftruncate", errno);
	}

	if(rw.from_size > 0)
	{
		if(cp_tmp->copy_mode == SAME)
		{
			buffer_size_local = buffer_size;
			for(;;)
			{
				rw.read_buf_num = 0;
				r_func((void *)&rw);
				rw.write_buf_num = 0;
				w_func((void *)&rw);

				if((rw.from_size <= total_write_local) || (rw.write_size <= 0))
					break;

				rw.read_buf_num = 1;
				r_func((void *)&rw);
				rw.write_buf_num = 1;
				w_func((void *)&rw);

				if((rw.from_size <= total_write_local) || (rw.write_size <= 0))
					break;
			}
		}
		else
		{
			// バッファを同時に二つ使用するので
			buffer_size_local = buffer_size / 2;
			rw.read_buf_num = 0;
			pthread_create(&t1, NULL, r_func, (void *)&rw);
			pthread_join(t1, NULL);
			for(;;)
			{
				rw.read_buf_num = 1;
				rw.write_buf_num = 0;
				pthread_create(&t1, NULL, r_func, (void *)&rw);
				pthread_create(&t2, NULL, w_func, (void *)&rw);
				pthread_join(t1, NULL);
				pthread_join(t2, NULL);

				if((rw.from_size <= total_write_local) || (rw.write_size <= 0))
					break;

				rw.read_buf_num = 0;
				rw.write_buf_num = 1;
				pthread_create(&t1, NULL, r_func, (void *)&rw);
				pthread_create(&t2, NULL, w_func, (void *)&rw);
				pthread_join(t1, NULL);
				pthread_join(t2, NULL);

				if((rw.from_size <= total_write_local) || (rw.write_size <= 0))
					break;
			}
		}
	}

	/*
	余計に書き込んだ部分を切り詰める。
	または大きなファイルを小さなファイルで上書きした場合のリサイズ。
	open時にO_TRUNCしてないので重要な処理。
	ここを弄ってバージョン0.1.2でバグを出したので、うかつに弄らない。
	*/
	if(ftruncate(rw.ito, rw.from_size) == -1)
			log_errors(__FILE__, __LINE__, errno, cp_tmp->to);

	total_read_local = 0;
	total_write_local = 0;

	if(close(rw.ifrom) == -1)
		log_errors(__FILE__, __LINE__, errno, cp_tmp->from);
	if(close(rw.ito) == -1)
		log_errors(__FILE__, __LINE__, errno, cp_tmp->to);

	ch_time_mod(&stat_buf, cp_tmp->to, REGULAR);

	write_now = NULL;

	if(compare_mode == 1)
	{
		if(V == VERBOS)
			printf("%sのコンペアを開始します\n", cp_tmp->to);

		if(C == COMPARE)
		{
			compare(cp_tmp->from, cp_tmp->to);
		}
		else if(C == ONE)
		{
			hash_function(cp_tmp->from, cp_tmp->to, cp_tmp->copy_mode, SHA1SUM);
		}
		else if(C == FIVE)
		{
			hash_function(cp_tmp->from, cp_tmp->to, cp_tmp->copy_mode, MD5SUM);
		}
	}
}

/*******************************************************************************
読み取り関数。pthreadで使うので仮引数はvoid *。
*******************************************************************************/
static void * r_func(void *read_t)
{
	struct fd_buf_num *tmp = (struct fd_buf_num *)read_t;
	int i = tmp->read_buf_num;
	if(tmp->from_size <= total_read_local)
	{
		next_write_size[i] = 0;
		return NULL;
	}

	/*
	読み込むデータのサイズ。
	ファイルサイズから既に読み込んだ量を引く。
	compare()からコピペ。
	*/
	long long read_size = tmp->from_size - total_read_local;
	if(read_size < buffer_size_local)
	{
		int j = read_size % 4096;
		if(j != read_size)
		{
			read_size = read_size - j;
		}
	}
	else
	{
		read_size = buffer_size_local;
	}

	errno = 0;
	buf[i] = mmap(NULL, read_size, PROT_READ , MAP_SHARED, tmp->ifrom, total_read_local);

	if(errno > 0)
	{
		log_errors(__FILE__, __LINE__, errno, write_now);
		errno = 0;
	}

	/*
	マルチスレッドの時、あまり速くない気がする
	スレッドから読み込むのはシーケンシャルじゃないってことか。
	if(madvise(buf[i], read_size, MADV_SEQUENTIAL) != 0)
	*/
	// こっちの方が速いような気がする
	if(madvise(buf[i], read_size, MADV_WILLNEED) != 0)
		log_errors(__FILE__, __LINE__, errno, write_now);
	total_read += read_size;
	total_read_local += read_size;
	next_write_size[i] = read_size;

	return NULL;
}

/*******************************************************************************
書き込み関数。pthreadで使うので仮引数はvoid *。
*******************************************************************************/
static void * w_func(void *write_t)
{
	struct fd_buf_num *tmp = (struct fd_buf_num *)write_t;
	errno = 0;

	int i = tmp->write_buf_num;
	long long write_off = 0;
	char *p = buf[i];
	const char * const endp = p + next_write_size[i];

	if(next_write_size[i] > 0)
	{
		for(;;)
		{
			long long bytes = write(tmp->ito, p, endp - p);
			write_off += bytes;
			// < だとerrno 14 (EFAULT) で無限ループに陥っていた
			if((bytes == next_write_size[i]) || bytes <= 0)
			{
				if(errno > 0)
				{
					log_errors(__FILE__, __LINE__, errno, write_now);
					errno = 0;
				}

				break;
			}
			p += bytes;
		}
	}

	if(munmap(buf[i], next_write_size[i]) == -1)
		log_errors(__FILE__, __LINE__, errno, write_now);

	if(write_off > 0)
	{
		total_write += write_off;
		total_write_local += write_off;
	}

	tmp->write_size = write_off;

	return NULL;
}
