#define _GNU_SOURCE

#include "global.h"
#include "enum.h"

#include "log.h"
#include "snowcp.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/mman.h>

// 関数プロトタイプ
void compare(char *from, char *to);

/*******************************************************************************
memcmpを使った単純比較を行う
*******************************************************************************/
void compare(char *from, char *to)
{
	struct stat stat_buf;
	int aa;
	int bb;
	long long size = 0;
	long long total_read = 0;
	long long read_size = 0;
	_Bool bcheck = true;
	errno = 0;

	if((aa = open(from, O_RDONLY | O_NOATIME)) == -1)
	{
		log_errors(__FILE__, __LINE__, errno, from);
		fprintf(stderr, "コンペアを開始できません\n");
		return;
	}
	if((bb = open(to, O_RDONLY | O_NOATIME)) == -1)
	{
		log_errors(__FILE__, __LINE__, errno, to);
		fprintf(stderr, "コンペアを開始できません\n");
		return;
	}
	// open出来たらここのチェックは必要ない？
	if(fstat(aa, &stat_buf) == -1)
	{
		log_errors(__FILE__, __LINE__, errno, from);
	}

	size = stat_buf.st_size;
	// サイズ0のファイルをマッピングするとエラー出すんで
	if(size == 0)
	{
		goto END;
	}
	else if(size < 0)
	{
		bcheck = false;
		goto END;
	}

	for(;;)
	{
		read_size = size - total_read;

		if(read_size < buffer_size)
		{
			// mmapの場合4096byteに満たないファイルをマッピングしても、消費するのは4096byte。
			// ここから、
			int i = read_size % 4096;
			if(i != read_size)
			{
				read_size = read_size - i;
			}
			// ここまで、マイシスター製。
			// ↑のようにすることでBus Error(SIGBUS)で落ちなくなった
		}
		else
		{
			read_size = buffer_size;
		}

		errno = 0;
		char *buf1 = mmap(NULL, read_size, PROT_READ , MAP_SHARED, aa, total_read);
		if(errno > 0)
		{
			log_errors(__FILE__, __LINE__, errno, from);
			munmap(buf1, read_size);
			fprintf(stderr, "ファイルマッピングエラー\n");
			bcheck = false;
			goto END;
		}
		char *buf2 = mmap(NULL, read_size, PROT_READ , MAP_SHARED, bb, total_read);
		if(errno > 0)
		{
			log_errors(__FILE__, __LINE__, errno, to);
			munmap(buf1, read_size);
			munmap(buf2, read_size);
			fprintf(stderr, "ファイルマッピングエラー\n");
			bcheck = false;
			goto END;
		}
		total_read += read_size;

		if(madvise(buf1, read_size, MADV_WILLNEED) == -1)
			log_errors(__FILE__, __LINE__, errno, from);
		if(madvise(buf2, read_size, MADV_WILLNEED) == -1)
			log_errors(__FILE__, __LINE__, errno, to);

		if(memcmp(buf1, buf2, read_size) != 0)
		{
			log_errors(__FILE__, __LINE__, errno, to);
			fprintf(stderr, "ファイルが一致しません。%sを削除します。\n", to);
			munmap(buf1, read_size);
			munmap(buf2, read_size);
			log_compares_write(from, "NULL", to, "NULL", false);
			unlink(to);
			bcheck = false;
			break;
		}
		else
		{
			if(total_read >= size)
			{
				munmap(buf1, read_size);
				munmap(buf2, read_size);
				break;
			}
		}

		munmap(buf1, read_size);
		munmap(buf2, read_size);
	}

END:
	close(aa);
	close(bb);

	if((V == VERBOS) && (bcheck == true))
	{
		printf("%s のコンペアが正常に終了しました\n", to);
	}

	if(bcheck == true)
	{
		log_compares_write(from, __FILE__, to, __FILE__, true);
	}
}
