#define _GNU_SOURCE

#include "struct_SDir.h"
#include "xmalloc.h" // inline

#include <errno.h>
#include <fcntl.h>
#include <glib.h>

// 関数プロトタイプ
SDir * get_settings_dir(void);

/*******************************************************************************
 * g_build_path()の戻り値はg_free()する必要有り。
*******************************************************************************/
SDir * get_settings_dir(void)
{
	// g_getenvの戻り値は const gchar *
	const char *homedir = g_getenv("HOME");

	if(!homedir)
	{
		homedir = g_get_home_dir();
	}

	SDir *sdir = xmalloc(sizeof(SDir));
	{
		char *tmp = g_build_path(G_DIR_SEPARATOR_S, homedir, ".config", NULL);
		sdir->config_dir = tmp; /* ~/.config */

		tmp = g_build_path(G_DIR_SEPARATOR_S, sdir->config_dir, "snowcp", NULL);
		sdir->user_settings_dir = tmp; /* ~/.config/snowcp */
	}

	errno = 0;
	if((sdir->current_fd = open(".", O_RDONLY | O_NOATIME)) == -1)
	{
		if(errno == EPERM)
		{
			errno = 0;
			if((sdir->current_fd = open(".", O_RDONLY)) == -1)
			{
				printf("errno is %d\n", errno);
				perror("get_settings_dir");
				exit(EXIT_FAILURE);
			}
		}
		else
		{
			printf("errno is %d\n", errno);
			perror("get_settings_dir");
			exit(EXIT_FAILURE);
		}
	}

	{
		char *tmp = g_build_path(G_DIR_SEPARATOR_S, sdir->user_settings_dir, "log", NULL);
		sdir->log_dir = tmp; /* ~/.config/snowcp/log */

		tmp = g_build_path(G_DIR_SEPARATOR_S, sdir->log_dir, "compare_error", NULL);
		sdir->hash_check_error_dir = tmp; /* ~/.config/snowcp/log/compare_error */

		tmp = g_build_path(G_DIR_SEPARATOR_S, sdir->log_dir, "compare_success", NULL);
		sdir->hash_check_success_dir = tmp; /* ~/.config/snowcp/log/compare_success */
	}

	return sdir;
}
