/*
 * Decompiled with CFR 0.152.
 */
package soba.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.JSRInlinerAdapter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import soba.core.ClassReadFailureException;
import soba.core.FieldInfo;
import soba.core.MD5;
import soba.core.MethodInfo;

public class ClassInfo {
    public static final String PACKAGE_SEPARATOR = "/";
    private static final String DEFAULT_PACKAGE = "$default$";
    public static final String LIBRARY_LABEL = "$library$";
    private String fileName;
    private String sourceFileName;
    private String packageName;
    private String className;
    private String md5hash;
    private String label;
    private List<MethodInfo> methods = new ArrayList<MethodInfo>();
    private List<FieldInfo> fields = new ArrayList<FieldInfo>();
    private String superclassName;
    private List<String> interfaceNames;

    public ClassInfo(String fileName, InputStream binaryStream, String loaderLabel) throws IOException {
        this(fileName, binaryStream);
        this.label = loaderLabel;
    }

    public ClassInfo(String fileName, InputStream binaryStream) throws IOException {
        ClassReader cr1;
        this.fileName = fileName;
        byte[] bytes = ClassInfo.readToEnd(binaryStream);
        try {
            cr1 = new ClassReader(bytes){

                public String readUTF8(int index, char[] buf) {
                    return super.readUTF8(index, buf);
                }
            };
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ClassReadFailureException("ASM ClassReader cannot parse the bytecode. " + fileName + " " + e.getLocalizedMessage());
        }
        ClassNode classNode = new ClassNode(327680){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                return new JSRInlinerAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc, signature, exceptions);
            }
        };
        cr1.accept((ClassVisitor)classNode, 0);
        this.className = classNode.name;
        int pkgIndex = this.className.lastIndexOf(PACKAGE_SEPARATOR);
        this.packageName = pkgIndex >= 0 ? this.className.substring(0, pkgIndex) : DEFAULT_PACKAGE;
        this.sourceFileName = classNode.sourceFile != null ? String.valueOf(this.getClassDirPath()) + File.separator + classNode.sourceFile : null;
        this.md5hash = MD5.getMD5(bytes);
        for (MethodNode m : classNode.methods) {
            this.methods.add(new MethodInfo(this, m));
        }
        int i = 0;
        while (i < classNode.fields.size()) {
            this.fields.add(new FieldInfo(this, (FieldNode)classNode.fields.get(i)));
            ++i;
        }
        this.superclassName = classNode.superName;
        this.interfaceNames = new ArrayList<String>(classNode.interfaces.size());
        i = 0;
        while (i < classNode.interfaces.size()) {
            this.interfaceNames.add((String)classNode.interfaces.get(i));
            ++i;
        }
    }

    private static byte[] readToEnd(InputStream stream) throws IOException {
        int n;
        byte[] buf = new byte[4096];
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        while ((n = stream.read(buf, 0, buf.length)) > 0) {
            buffer.write(buf, 0, n);
        }
        return buffer.toByteArray();
    }

    public static ClassInfo createLibraryClass(String fileName, InputStream binaryStream) throws IOException {
        ClassInfo c = new ClassInfo(fileName, binaryStream);
        c.label = LIBRARY_LABEL;
        return c;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperClass() {
        return this.superclassName;
    }

    public List<String> getInterfaces() {
        return this.interfaceNames;
    }

    public String getHash() {
        return this.md5hash;
    }

    public String getClassDirPath() {
        return this.packageName.replace('/', File.separatorChar);
    }

    public String getClassFileName() {
        return this.fileName;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isLibrary() {
        return this.getLabel() == LIBRARY_LABEL;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public int getMethodCount() {
        return this.methods.size();
    }

    public MethodInfo getMethod(int methodIndex) {
        return this.methods.get(methodIndex);
    }

    public List<MethodInfo> getMethods() {
        return this.methods;
    }

    public MethodInfo findMethod(String methodName, String methodDesc) {
        for (MethodInfo m : this.methods) {
            if (!m.getMethodName().equals(methodName) || !m.getDescriptor().equals(methodDesc)) continue;
            return m;
        }
        return null;
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public FieldInfo getField(int fieldIndex) {
        return this.fields.get(fieldIndex);
    }

    public List<FieldInfo> getFields() {
        return this.fields;
    }

    public FieldInfo findField(String fieldName, String fieldDesc) {
        for (FieldInfo f : this.fields) {
            if (!f.getFieldName().equals(fieldName) || !f.getDescriptor().equals(fieldDesc)) continue;
            return f;
        }
        return null;
    }
}

