/*
 * Decompiled with CFR 0.152.
 */
package soba.core;

import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import soba.core.ExampleProgram;
import soba.core.JavaProgram;
import soba.util.files.Directory;
import soba.util.files.IClassList;

public class JavaProgramTest
implements ExampleProgram {
    private static JavaProgram program;

    public static JavaProgram readExampleProgram() {
        Directory dir = new Directory(new File("bin/soba/testdata/"));
        JavaProgram program = new JavaProgram(new IClassList[]{dir});
        return program;
    }

    @BeforeClass
    public static void setUpBeforeClass() {
        program = JavaProgramTest.readExampleProgram();
    }

    @Test
    public void testJavaProgram01() {
        Assert.assertThat(program.getClasses(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat(program.getClasses(), (Matcher)Matchers.hasSize((int)22));
        Assert.assertThat(program.getFiltered(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Assert.assertThat(program.getDuplicated(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Assert.assertThat(program.getErrors(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)program.getClassHierarchy(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)program.getClassInfo("soba/testdata/inheritance1/C"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)program.getClassInfo("soba/testdata/inheritance1/D"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)program.getClassInfo("soba/testdata/inheritance2/E"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)program.getClassInfo("soba/testdata/inheritance2/F"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)program.getClassInfo("soba/testdata/inheritance1/G"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)program.getClassInfo("soba/testdata/inheritance2/H"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)program.getClassInfo("soba/testdata/inheritance1/I"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)program.getClassInfo("soba/testdata/inheritance1/J"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)program.getClassInfo("soba/testdata/inheritance1/K"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)program.getClassInfo("NotExistClass"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }
}

