/*
 * Decompiled with CFR 0.152.
 */
package soba.core;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import soba.core.ClassInfo;
import soba.core.method.CallSite;
import soba.core.method.ControlDependence;
import soba.core.method.DataDependence;
import soba.core.method.FieldAccess;
import soba.core.method.OpcodeString;
import soba.core.method.asm.DataFlowAnalyzer;
import soba.core.method.asm.DataFlowInterpreter;
import soba.core.signature.MethodSignatureReader;
import soba.util.ObjectIdMap;
import soba.util.graph.DirectedGraph;

public class MethodInfo {
    private ClassInfo ownerClass;
    private MethodNode method;
    private String returnType;
    private String[] paramTypes;
    private int[] paramIndex;
    private int paramCount;
    private boolean[] paramGeneric;
    private int[] lines;
    private int maxLine;
    private int minLine;
    private DataFlowAnalyzer analyzer;
    private DataDependence dataDependence;

    public MethodInfo(ClassInfo owner, MethodNode method) {
        this.ownerClass = owner;
        this.method = method;
    }

    public String getPackageName() {
        return this.ownerClass.getPackageName();
    }

    public String getClassName() {
        return this.ownerClass.getClassName();
    }

    public String getMethodName() {
        return this.method.name;
    }

    public String getDescriptor() {
        return this.method.desc;
    }

    public String getGenericsSignature() {
        return this.method.signature;
    }

    public boolean hasMethodBody() {
        return (this.method.access & 0x500) == 0;
    }

    public boolean isLibrary() {
        return this.ownerClass.isLibrary();
    }

    public boolean isStatic() {
        return (this.method.access & 8) != 0;
    }

    public boolean isSynthetic() {
        return (this.method.access & 0x1000) != 0;
    }

    public boolean isPublic() {
        return (this.method.access & 1) != 0;
    }

    public boolean isProtected() {
        return (this.method.access & 4) != 0;
    }

    public boolean isPrivate() {
        return (this.method.access & 2) != 0;
    }

    public boolean isPackagePrivate() {
        return (this.method.access & 7) == 0;
    }

    public boolean isOverridable() {
        return (this.method.access & 0x1A) == 0;
    }

    public int getInstructionCount() {
        return this.method.instructions.size();
    }

    public AbstractInsnNode getAbstractInsnNode(int instructionIndex) {
        return this.method.instructions.get(instructionIndex);
    }

    public String getReturnType() {
        this.extractParametersIfNecessary();
        return this.returnType;
    }

    public int getParamCount() {
        this.extractParametersIfNecessary();
        return this.paramCount;
    }

    public int getReceiverObjectParamIndex() {
        assert (!this.isStatic());
        return 0;
    }

    public int getVariableTableIndexOfParamAt(int index) {
        return this.paramIndex[index];
    }

    public int getParameterOrderingNumber(int localVarialbleIndex) {
        int p = 0;
        while (p < this.paramCount) {
            if (this.paramIndex[p] == localVarialbleIndex) {
                return p;
            }
            ++p;
        }
        throw new IllegalArgumentException("getParameterOrderingNumber:" + localVarialbleIndex + " is not Parameter");
    }

    public boolean isParameterOrderingNumber(int localVarialbleIndex) {
        int p = 0;
        while (p < this.paramCount) {
            if (this.paramIndex[p] == localVarialbleIndex) {
                return true;
            }
            ++p;
        }
        return false;
    }

    public String getParamType(int index) {
        this.extractParametersIfNecessary();
        if (index >= this.paramTypes.length) {
            return null;
        }
        return this.paramTypes[index];
    }

    public String getParamName(int index) {
        if (this.method.localVariables == null) {
            return null;
        }
        if (index >= this.method.localVariables.size()) {
            return null;
        }
        int paramIndex = this.getVariableTableIndexOfParamAt(index);
        int i = 0;
        while (i < this.method.localVariables.size()) {
            LocalVariableNode var = (LocalVariableNode)this.method.localVariables.get(i);
            if (var.index == paramIndex && var.start == this.method.instructions.getFirst()) {
                return var.name;
            }
            ++i;
        }
        return null;
    }

    private void extractParametersIfNecessary() {
        if (this.paramTypes != null) {
            return;
        }
        MethodSignatureReader reader = new MethodSignatureReader(this.method.desc);
        int thisParam = this.isStatic() ? 0 : 1;
        this.returnType = reader.getReturnType();
        this.paramCount = reader.getParamCount() + thisParam;
        String[] params = new String[this.paramCount];
        if (!this.isStatic()) {
            params[0] = this.getClassName() != null ? this.getClassName() : "(Owner-Class)";
        }
        int i = 0;
        while (i < reader.getParamCount()) {
            params[i + thisParam] = reader.getParamType(i);
            ++i;
        }
        this.paramGeneric = new boolean[this.paramCount];
        i = 0;
        while (i < reader.getParamCount()) {
            this.paramGeneric[i + thisParam] = reader.isGenericType(i);
            ++i;
        }
        this.paramIndex = new int[params.length];
        int index = 0;
        int i2 = 0;
        while (i2 < params.length) {
            this.paramIndex[i2] = index++;
            if (params[i2].equals("double") || params[i2].equals("long")) {
                index += 2;
            }
            ++i2;
        }
        this.paramTypes = params;
    }

    public MethodNode getMethodNode() {
        return this.method;
    }

    private void computeMinMaxLine() {
        if (this.lines == null) {
            TIntHashSet array = new TIntHashSet(this.method.instructions.size());
            int i = 0;
            while (i < this.method.instructions.size()) {
                if (this.method.instructions.get(i).getType() == 15) {
                    LineNumberNode node = (LineNumberNode)this.method.instructions.get(i);
                    array.add(node.line);
                }
                ++i;
            }
            if (array.isEmpty()) {
                this.lines = new int[0];
                this.maxLine = 0;
                this.minLine = 0;
            } else {
                this.lines = array.toArray();
                Arrays.sort(this.lines);
                this.maxLine = this.lines[this.lines.length - 1];
                this.minLine = this.lines[0];
            }
        }
    }

    public int getMaxLine() {
        this.computeMinMaxLine();
        return this.maxLine;
    }

    public int getMinLine() {
        this.computeMinMaxLine();
        return this.minLine;
    }

    public int[] getLineNumbers() {
        this.computeMinMaxLine();
        return this.lines;
    }

    public int getLine(int instructionIndex) {
        int i = instructionIndex;
        while (i >= 0) {
            if (this.method.instructions.get(i).getType() == 15) {
                return ((LineNumberNode)this.method.instructions.get((int)i)).line;
            }
            --i;
        }
        return 0;
    }

    public int[] getInstructions(int line) {
        TIntArrayList lineInstructions = new TIntArrayList();
        boolean inside = false;
        int i = 0;
        while (i < this.method.instructions.size()) {
            if (this.method.instructions.get(i).getType() == 15) {
                boolean bl = inside = ((LineNumberNode)this.method.instructions.get((int)i)).line == line;
            }
            if (inside) {
                lineInstructions.add(i);
            }
            ++i;
        }
        return lineInstructions.toArray();
    }

    public List<CallSite> getCallSites() {
        ArrayList<CallSite> callsites = new ArrayList<CallSite>(this.method.instructions.size());
        int i = 0;
        while (i < this.method.instructions.size()) {
            CallSite c = this.getCallSite(i);
            if (c != null) {
                callsites.add(c);
            }
            ++i;
        }
        return callsites;
    }

    public CallSite getCallSite(int instructionIndex) {
        if (this.method.instructions.get(instructionIndex).getType() == 5) {
            MethodInsnNode m = (MethodInsnNode)this.method.instructions.get(instructionIndex);
            return new CallSite(this, instructionIndex, m.owner, m.name, m.desc, this.getInvokeType(m));
        }
        return null;
    }

    private CallSite.Kind getInvokeType(MethodInsnNode m) {
        CallSite.Kind k = CallSite.Kind.VIRTUAL;
        if (m.getOpcode() == 184) {
            k = CallSite.Kind.STATIC;
        } else if (m.getOpcode() == 183) {
            k = CallSite.Kind.SPECIAL;
        }
        return k;
    }

    public List<FieldAccess> getFieldAccesses() {
        ArrayList<FieldAccess> fields = new ArrayList<FieldAccess>(32);
        int i = 0;
        while (i < this.method.instructions.size()) {
            FieldAccess fieldAccess;
            if (this.method.instructions.get(i).getType() == 4 && (fieldAccess = this.getFieldAccess(i)) != null) {
                fields.add(fieldAccess);
            }
            ++i;
        }
        return fields;
    }

    public FieldAccess getFieldAccess(int instructionIndex) {
        assert (this.method.instructions.get(instructionIndex).getType() == 4);
        FieldInsnNode f = (FieldInsnNode)this.method.instructions.get(instructionIndex);
        switch (f.getOpcode()) {
            case 181: {
                return FieldAccess.createPutField(f.owner, f.name, f.desc, false);
            }
            case 179: {
                return FieldAccess.createPutField(f.owner, f.name, f.desc, true);
            }
            case 180: {
                return FieldAccess.createGetField(f.owner, f.name, f.desc, false);
            }
            case 178: {
                return FieldAccess.createGetField(f.owner, f.name, f.desc, true);
            }
        }
        assert (false) : "Unknown Field Operation Found.";
        return null;
    }

    public int[] getReturnInstructions() {
        TIntHashSet returns = new TIntHashSet();
        int i = 0;
        while (i < this.method.instructions.size()) {
            AbstractInsnNode ain = this.method.instructions.get(i);
            if (OpcodeString.isReturnOperation(ain)) {
                returns.add(i);
            }
            ++i;
        }
        return returns.toArray();
    }

    public DataDependence getDataDependence() {
        this.computeFlow();
        return this.dataDependence;
    }

    public DirectedGraph getControlDependence() {
        return ControlDependence.getDependence(this.getInstructionCount(), this.getControlFlow());
    }

    public DirectedGraph getControlFlow() {
        this.computeFlow();
        return new DirectedGraph(this.getInstructionCount(), this.analyzer.getNormalControlFlow());
    }

    public DirectedGraph getConservativeControlFlow() {
        this.computeFlow();
        return new DirectedGraph(this.getInstructionCount(), this.analyzer.getConservativeControlFlow());
    }

    private void computeFlow() {
        if (this.analyzer == null) {
            ObjectIdMap<AbstractInsnNode> instructions = new ObjectIdMap<AbstractInsnNode>(this.method.instructions.size());
            int i = 0;
            while (i < this.method.instructions.size()) {
                instructions.add(this.method.instructions.get(i));
                ++i;
            }
            instructions.freeze();
            DataFlowInterpreter interpreter = new DataFlowInterpreter(instructions);
            this.analyzer = new DataFlowAnalyzer(interpreter);
            try {
                this.analyzer.analyze(this.method.name, this.method);
                this.dataDependence = new DataDependence(instructions, this.analyzer);
            }
            catch (AnalyzerException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public String getMethodKey() {
        return String.valueOf(this.getClassName()) + "#" + this.getMethodName() + "#" + this.getDescriptor();
    }

    public String getInstructionString(int instructionIndex) {
        return OpcodeString.getInstructionString(this.method, instructionIndex);
    }

    public String toString() {
        return String.valueOf(this.getMethodName()) + this.getDescriptor();
    }

    public String toLongString() {
        StringBuilder name = new StringBuilder();
        if (this.getClassName() != null) {
            name.append(this.getClassName());
            name.append(".");
        }
        name.append(this.getMethodName());
        name.append("(");
        int i = 0;
        while (i < this.getParamCount()) {
            if (i > 0) {
                name.append(", ");
            }
            name.append(this.getParamType(i));
            String paramName = this.getParamName(i);
            if (paramName != null) {
                name.append(":");
                name.append(paramName);
            }
            ++i;
        }
        name.append(")");
        name.append(": ");
        name.append(this.getReturnType());
        return name.toString();
    }
}

