/*
 * Decompiled with CFR 0.152.
 */
package soba.core.method;

import java.util.Arrays;
import soba.util.IntPairList;
import soba.util.IntPairProc;
import soba.util.IntPairSet;
import soba.util.graph.DepthFirstSearch;
import soba.util.graph.DirectedGraph;
import soba.util.graph.DominanceTree;
import soba.util.graph.IDepthFirstVisitor;
import soba.util.graph.SingleRootDirectedGraph;

public class ControlDependence {
    public static DirectedGraph getDependence(int instructionCount, DirectedGraph controlFlowGraph) {
        DirectedGraph reverseControlFlow = controlFlowGraph.getReverseGraph();
        SingleRootDirectedGraph rootGraph = new SingleRootDirectedGraph(reverseControlFlow);
        DominanceTree tree = new DominanceTree(rootGraph);
        final IntPairList controlDependenceCandidate = new IntPairList();
        int i = 0;
        while (i < instructionCount) {
            if (controlFlowGraph.getEdges(i).length > 1) {
                final int postDom = tree.getDominator(i);
                DepthFirstSearch.search(controlFlowGraph, i, new IDepthFirstVisitor(){
                    private int start;

                    @Override
                    public void onStart(int startVertexId) {
                        this.start = startVertexId;
                    }

                    @Override
                    public boolean onVisit(int vertexId) {
                        if (this.start != vertexId && vertexId != postDom) {
                            controlDependenceCandidate.add(this.start, vertexId);
                        }
                        return vertexId != postDom;
                    }

                    @Override
                    public void onVisitAgain(int vertexId) {
                    }

                    @Override
                    public void onLeave(int vertexId) {
                    }

                    @Override
                    public void onFinished(boolean[] visited) {
                    }
                });
            }
            ++i;
        }
        DirectedGraph candidate = new DirectedGraph(instructionCount, controlDependenceCandidate);
        final IntPairSet redundantEdges = new IntPairSet();
        int src = 0;
        while (src < instructionCount) {
            int[] nArray = candidate.getEdges(src);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int[] edges;
                int v = nArray[n2];
                if (controlFlowGraph.getEdges(v).length > 1 && Arrays.binarySearch(edges = candidate.getEdges(v), src) < 0) {
                    int[] nArray2 = candidate.getEdges(v);
                    int n3 = nArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int d = nArray2[n4];
                        redundantEdges.add(src, d);
                        ++n4;
                    }
                }
                ++n2;
            }
            ++src;
        }
        final IntPairList controlDependence = new IntPairList();
        controlDependenceCandidate.foreach(new IntPairProc(){

            @Override
            public boolean execute(int elem1, int elem2) {
                if (!redundantEdges.contains(elem1, elem2)) {
                    controlDependence.add(elem1, elem2);
                }
                return true;
            }
        });
        return new DirectedGraph(instructionCount, controlDependence);
    }
}

