/*
 * Decompiled with CFR 0.152.
 */
package soba.core.method;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import soba.core.JavaProgram;
import soba.core.JavaProgramTest;
import soba.core.MethodInfo;
import soba.core.method.DataDependence;
import soba.core.method.DataFlowEdge;
import soba.util.UtilForAssertThat;
import soba.util.graph.DirectedGraph;

public class DataDependenceTest {
    private static JavaProgram program;

    @BeforeClass
    public static void setUpBeforeClass() {
        program = JavaProgramTest.readExampleProgram();
    }

    @Test
    public void testDataDependence01() {
        MethodInfo m = program.getClassInfo("soba/testdata/DefUseTestData").findMethod("overwriteParam", "(II)V");
        DataDependence dd = m.getDataDependence();
        Assert.assertThat((Object)dd, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        List<DataFlowEdge> edges = dd.getEdges();
        Assert.assertThat(edges, (Matcher)Matchers.hasSize((int)7));
        Assert.assertThat((Object)this.containsEdge(edges, -1, 2), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(edges, 2, 3), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(edges, 4, 5), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(edges, -1, 10), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(edges, 5, 10), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(edges, 9, 11), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(edges, 10, 11), (Matcher)Matchers.is((Object)true));
        List<DataFlowEdge> edgesSourceOrder = dd.getEdgesInSourceOrder();
        Assert.assertThat(edgesSourceOrder, (Matcher)Matchers.hasSize((int)7));
        Assert.assertThat((Object)this.containsEdgeAt(edgesSourceOrder, -1, 2, 0), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdgeAt(edgesSourceOrder, -1, 10, 1), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdgeAt(edgesSourceOrder, 2, 3, 2), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdgeAt(edgesSourceOrder, 4, 5, 3), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdgeAt(edgesSourceOrder, 5, 10, 4), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdgeAt(edgesSourceOrder, 9, 11, 5), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdgeAt(edgesSourceOrder, 10, 11, 6), (Matcher)Matchers.is((Object)true));
        DirectedGraph dependence = dd.getDependenceGraph();
        Assert.assertThat((Object)dependence.getVertexCount(), (Matcher)Matchers.is((Object)m.getInstructionCount()));
        Assert.assertThat((Object)dependence.getEdgeCount(), (Matcher)Matchers.is((Object)5));
        Integer[] edgesFrom0 = UtilForAssertThat.asIntegerArray(dependence.getEdges(0));
        Integer[] edgesFrom1 = UtilForAssertThat.asIntegerArray(dependence.getEdges(1));
        Integer[] edgesFrom2 = UtilForAssertThat.asIntegerArray(dependence.getEdges(2));
        Integer[] edgesFrom3 = UtilForAssertThat.asIntegerArray(dependence.getEdges(3));
        Integer[] edgesFrom4 = UtilForAssertThat.asIntegerArray(dependence.getEdges(4));
        Integer[] edgesFrom5 = UtilForAssertThat.asIntegerArray(dependence.getEdges(5));
        Integer[] edgesFrom6 = UtilForAssertThat.asIntegerArray(dependence.getEdges(6));
        Integer[] edgesFrom7 = UtilForAssertThat.asIntegerArray(dependence.getEdges(7));
        Integer[] edgesFrom8 = UtilForAssertThat.asIntegerArray(dependence.getEdges(8));
        Integer[] edgesFrom9 = UtilForAssertThat.asIntegerArray(dependence.getEdges(9));
        Integer[] edgesFrom10 = UtilForAssertThat.asIntegerArray(dependence.getEdges(10));
        Integer[] edgesFrom11 = UtilForAssertThat.asIntegerArray(dependence.getEdges(11));
        Integer[] edgesFrom12 = UtilForAssertThat.asIntegerArray(dependence.getEdges(12));
        Integer[] edgesFrom13 = UtilForAssertThat.asIntegerArray(dependence.getEdges(13));
        Integer[] edgesFrom14 = UtilForAssertThat.asIntegerArray(dependence.getEdges(14));
        Integer[] edgesFrom15 = UtilForAssertThat.asIntegerArray(dependence.getEdges(15));
        Assert.assertThat((Object)edgesFrom2, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{3})));
        Assert.assertThat((Object)edgesFrom4, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{5})));
        Assert.assertThat((Object)edgesFrom5, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{10})));
        Assert.assertThat((Object)edgesFrom9, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{11})));
        Assert.assertThat((Object)edgesFrom10, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{11})));
        Assert.assertThat((Object)edgesFrom0, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)edgesFrom1, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)edgesFrom3, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)edgesFrom6, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)edgesFrom7, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)edgesFrom8, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)edgesFrom11, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)edgesFrom12, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)edgesFrom13, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)edgesFrom14, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)edgesFrom15, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        List<DataFlowEdge> incomingEdges2 = dd.getIncomingEdges(2);
        Assert.assertThat(incomingEdges2, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.containsEdge(incomingEdges2, -1, 2), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)dd.getVariableName(incomingEdges2.get(0)), (Matcher)Matchers.is((Object)"x"));
        Assert.assertThat((Object)dd.getVariableDescriptor(incomingEdges2.get(0)), (Matcher)Matchers.is((Object)"I"));
        List<DataFlowEdge> incomingEdges11 = dd.getIncomingEdges(11);
        Assert.assertThat(incomingEdges11, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)this.containsEdge(incomingEdges11, 9, 11), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(incomingEdges11, 10, 11), (Matcher)Matchers.is((Object)true));
        DataFlowEdge incomingEdge11At0 = dd.getIncomingEdge(11, 0);
        Assert.assertThat((Object)incomingEdge11At0.getSourceInstruction(), (Matcher)Matchers.is((Object)9));
        DataFlowEdge incommingEdge11At1 = dd.getIncomingEdge(11, 1);
        Assert.assertThat((Object)incommingEdge11At1.getSourceInstruction(), (Matcher)Matchers.is((Object)10));
        List<DataFlowEdge> incomingEdges11At0 = dd.getIncomingEdges(11, 0);
        Assert.assertThat(incomingEdges11At0, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.containsEdge(incomingEdges11At0, 9, 11), (Matcher)Matchers.is((Object)true));
        List<DataFlowEdge> incomingEdges11At1 = dd.getIncomingEdges(11, 1);
        Assert.assertThat(incomingEdges11At1, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.containsEdge(incomingEdges11At1, 10, 11), (Matcher)Matchers.is((Object)true));
        int[][] definition10 = dd.getDataDefinition(10);
        Assert.assertThat((Object)definition10.length, (Matcher)Matchers.is((Object)1));
        Integer[] local = UtilForAssertThat.asIntegerArray(definition10[0]);
        Assert.assertThat((Object)local, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{-1, 5})));
        int[][] definition11 = dd.getDataDefinition(11);
        Assert.assertThat((Object)definition11.length, (Matcher)Matchers.is((Object)2));
        Integer[] operand0 = UtilForAssertThat.asIntegerArray(definition11[0]);
        Integer[] operand1 = UtilForAssertThat.asIntegerArray(definition11[1]);
        Assert.assertThat((Object)operand0, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{9})));
        Assert.assertThat((Object)operand1, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{10})));
        Assert.assertThat((Object)dd.getOperandCount(2), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)dd.getOperandCount(3), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dd.getOperandCount(11), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testDataDependence02() {
        MethodInfo m = program.getClassInfo("soba/testdata/DefUseTestData").findMethod("localDataDependence", "()V");
        DataDependence dd = m.getDataDependence();
        Assert.assertThat((Object)dd, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        List<DataFlowEdge> edges = dd.getEdges();
        Assert.assertThat(edges, (Matcher)Matchers.hasSize((int)17));
        Assert.assertThat((Object)this.containsEdge(edges, 2, 3), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(edges, 3, 6), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(edges, 6, 7), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(edges, 10, 11), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(edges, 18, 19), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(edges, 19, 23), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(edges, 22, 24), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(edges, 23, 24), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(edges, 27, 28), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(edges, 11, 33), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(edges, 28, 33), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(edges, 32, 34), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(edges, 11, 38), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(edges, 28, 38), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(edges, 37, 39), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsEdge(edges, 38, 39), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testDataDependence03() {
        MethodInfo m = program.getClassInfo("soba/testdata/DefUseTestData").findMethod("tryFinallyDependence", "()I");
        DataDependence dd = m.getDataDependence();
        Assert.assertThat((Object)dd, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    private boolean containsEdge(List<DataFlowEdge> edges, int from, int to) {
        for (DataFlowEdge e : edges) {
            if (e.getSourceInstruction() != from || e.getDestinationInstruction() != to) continue;
            return true;
        }
        return false;
    }

    private boolean containsEdgeAt(List<DataFlowEdge> edges, int from, int to, int pos) {
        return edges.size() > pos && edges.get(pos).getSourceInstruction() == from && edges.get(pos).getDestinationInstruction() == to;
    }
}

