/*
 * Decompiled with CFR 0.152.
 */
package soba.core.method;

import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import soba.core.method.DataDependence;
import soba.core.method.DataFlowEdge;
import soba.core.method.OpcodeString;
import soba.core.signature.TypeResolver;
import soba.util.IntPairProc;
import soba.util.IntPairSet;

public class LocalVariables {
    private ArrayList<Entry> entries;
    private MethodNode m;

    public LocalVariables(DataDependence dataDependence, MethodNode node) {
        this.m = node;
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (DataFlowEdge edge : dataDependence.getEdges()) {
            if (!edge.isLocal()) continue;
            int[] index = LocalVariables.findEntries(entries, edge);
            if (index[0] != -1) {
                Entry e1 = entries.get(index[0]);
                if (index[1] == -1) {
                    e1.add(edge);
                    this.checkObjectFlag(e1, dataDependence, edge);
                    continue;
                }
                if (index[1] != index[0]) {
                    Entry e2 = entries.remove(index[1]);
                    e1.merge(e2);
                    continue;
                }
                this.checkObjectFlag(e1, dataDependence, edge);
                continue;
            }
            Entry e = new Entry(edge);
            entries.add(e);
            this.checkObjectFlag(e, dataDependence, edge);
        }
        List variables = node.localVariables;
        int i = 0;
        while (i < variables.size()) {
            LocalVariableNode var = (LocalVariableNode)variables.get(i);
            for (Entry e : entries) {
                if (!e.isDataflowOf(var)) continue;
                e.addLocalVariableNode(var);
            }
            ++i;
        }
        this.entries = entries;
        i = 0;
        while (i < node.instructions.size()) {
            int entry;
            AbstractInsnNode instruction = node.instructions.get(i);
            if ((OpcodeString.isStoreOperation(instruction) || OpcodeString.isLoadOperation(instruction)) && (entry = this.findEntryForInstruction(i)) == -1) {
                Entry e = new Entry(i, (VarInsnNode)instruction);
                this.entries.add(e);
            }
            ++i;
        }
    }

    private void checkObjectFlag(Entry e, DataDependence dataflow, DataFlowEdge edge) {
        AbstractInsnNode varNode = dataflow.getInstruction(edge.getDestinationInstruction());
        if (varNode.getOpcode() == 25) {
            e.setObjectTypeEntry(true);
        }
        if (edge.getSourceInstruction() >= 0) {
            varNode = dataflow.getInstruction(edge.getSourceInstruction());
            if (varNode.getOpcode() == 58) {
                e.setObjectTypeEntry(true);
            } else if (edge.getDestinationOperandIndex() == 0 && (varNode.getOpcode() == 50 || varNode.getOpcode() == 83)) {
                e.setArrayTypeEntry(true);
            }
        }
    }

    public int getVariableEntryCount() {
        return this.entries.size();
    }

    public String getVariableName(int entryIndex) {
        return this.entries.get(entryIndex).getVariableName();
    }

    public String getDescriptor(int entryIndex) {
        return this.entries.get(entryIndex).getDesc();
    }

    public String getVariableType(int entryIndex) {
        return this.entries.get(entryIndex).getTypeName();
    }

    public int getVariableIndex(int entryIndex) {
        return this.entries.get(entryIndex).getVariableIndex();
    }

    public boolean isObjectVariable(int entryIndex) {
        return this.entries.get(entryIndex).isObjectType();
    }

    public boolean isArrayVariable(int entryIndex) {
        return this.entries.get(entryIndex).isArrayType();
    }

    public boolean hasNoDataDependence(int entryIndex) {
        return this.entries.get(entryIndex).isAlone();
    }

    public boolean isParameter(int entryIndex) {
        return this.entries.get(entryIndex).isParameter();
    }

    public int findEntryForInstruction(int instructionIndex) {
        int i = 0;
        while (i < this.entries.size()) {
            Entry e = this.entries.get(i);
            if (e.containsSource(instructionIndex) || e.containsDestination(instructionIndex)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int[] findEntries(ArrayList<Entry> entries, DataFlowEdge edge) {
        int[] ret = new int[]{-1, -1};
        int i = 0;
        while (i < entries.size()) {
            Entry e = entries.get(i);
            if (e.isConnected(edge)) {
                if (ret[0] == -1) {
                    ret[0] = i;
                } else if (ret[1] == -1) {
                    ret[1] = i;
                    return ret;
                }
            }
            ++i;
        }
        return ret;
    }

    private class Entry {
        private TIntHashSet defs;
        private TIntHashSet refs;
        private IntPairSet refWithOperands;
        private int variableIndex;
        private boolean isObjectType;
        private boolean isArrayType;
        private String typeName;
        private String typeNameWithGenerics;
        private String variableName;
        private String desc;
        private ArrayList<LocalVariableNode> variables;
        private boolean isParam;
        private boolean isAlone;

        private Entry(DataFlowEdge e) {
            this.variableIndex = e.getVariableIndex();
            this.variables = new ArrayList();
            this.defs = new TIntHashSet();
            this.defs.add(e.getSourceInstruction());
            this.refs = new TIntHashSet();
            this.refs.add(e.getDestinationInstruction());
            this.refWithOperands = new IntPairSet();
            this.refWithOperands.add(e.getDestinationInstruction(), e.getDestinationOperandIndex());
            this.isParam = e.isParameter();
            this.isAlone = false;
        }

        private Entry(int instructionIndex, VarInsnNode var) {
            assert (OpcodeString.isStoreOperation((AbstractInsnNode)var) || OpcodeString.isAfterJSR((AbstractInsnNode)var)) : "A STORE instruction may exist without LOAD instructions. But there are no LOAD instructions without STORE.";
            this.variableIndex = var.var;
            this.variables = new ArrayList(1);
            this.defs = new TIntHashSet(2);
            this.defs.add(instructionIndex);
            this.refs = new TIntHashSet();
            this.refWithOperands = new IntPairSet();
            this.isParam = false;
            this.isObjectType = var.getOpcode() == 58;
            this.isAlone = true;
        }

        public boolean isParameter() {
            return this.defs.contains(-1);
        }

        public boolean isAlone() {
            return this.isAlone;
        }

        private void setObjectTypeEntry(boolean value) {
            this.isObjectType = value;
        }

        private void setArrayTypeEntry(boolean value) {
            this.isArrayType = value;
        }

        private void add(DataFlowEdge e) {
            assert (this.variableIndex == e.getVariableIndex());
            this.defs.add(e.getSourceInstruction());
            this.refs.add(e.getDestinationInstruction());
            this.refWithOperands.add(e.getDestinationInstruction(), e.getDestinationOperandIndex());
            this.isParam = this.isParam || e.isParameter();
        }

        private void merge(Entry another) {
            assert (this.variableIndex == another.variableIndex);
            this.defs.addAll(another.defs.toArray());
            another.refWithOperands.foreach(new IntPairProc(){

                @Override
                public boolean execute(int instructionIndex, int operand) {
                    Entry.this.refs.add(instructionIndex);
                    Entry.this.refWithOperands.add(instructionIndex, operand);
                    return true;
                }
            });
            if (another.isObjectType) {
                this.isObjectType = another.isObjectType;
            }
        }

        private boolean isDataflowOf(LocalVariableNode var) {
            if (this.variableIndex == var.index) {
                for (int def : this.defs) {
                    AbstractInsnNode defNode;
                    if (!(def >= 0 && def < ((LocalVariables)LocalVariables.this).m.instructions.size() ? OpcodeString.isAccess(defNode = ((LocalVariables)LocalVariables.this).m.instructions.get(def), var) : var.start == ((LocalVariables)LocalVariables.this).m.instructions.getFirst())) continue;
                    return true;
                }
                for (int ref : this.refs) {
                    AbstractInsnNode refNode = ((LocalVariables)LocalVariables.this).m.instructions.get(ref);
                    if (!OpcodeString.isAccess(refNode, var)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        private void addLocalVariableNode(LocalVariableNode node) {
            this.variables.add(node);
            if (this.variableName == null) {
                this.variableName = node.name;
            } else assert (node.name == null || this.variableName.equals(node.name)) : "Combined " + this.variableName.toString() + " and " + node.name;
            if (this.typeName == null) {
                if (node.desc != null) {
                    this.desc = node.desc;
                    this.typeName = TypeResolver.getTypeName(node.desc);
                }
            } else assert (node.desc == null || this.typeName.equals(TypeResolver.getTypeName(node.desc)));
            if (this.typeNameWithGenerics == null) {
                if (node.signature != null) {
                    this.typeNameWithGenerics = TypeResolver.getTypeName(node.signature);
                }
            } else assert (node.signature == null || this.typeNameWithGenerics.equals(TypeResolver.getTypeName(node.signature)));
        }

        private boolean isConnected(DataFlowEdge edge) {
            return this.variableIndex == edge.getVariableIndex() && this.containsSource(edge.getSourceInstruction()) || this.containsDestinationOperand(edge.getDestinationInstruction(), edge.getDestinationOperandIndex());
        }

        private boolean containsSource(int instruction) {
            return this.defs.contains(instruction);
        }

        private boolean containsDestination(int instruction) {
            return this.refWithOperands.containsFirst(instruction);
        }

        private boolean containsDestinationOperand(int instruction, int operandIndex) {
            return this.refWithOperands.contains(instruction, operandIndex);
        }

        private boolean isObjectType() {
            return this.isObjectType;
        }

        private boolean isArrayType() {
            return this.isArrayType;
        }

        private int getVariableIndex() {
            return this.variableIndex;
        }

        private String getTypeName() {
            return this.typeName;
        }

        private String getVariableName() {
            return this.variableName;
        }

        private String getDesc() {
            return this.desc;
        }
    }
}

