/*
 * Decompiled with CFR 0.152.
 */
package soba.core.method;

import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import soba.core.signature.TypeResolver;

public class OpcodeString {
    public static final String TYPE_PRIMITIVE = "P";
    public static final String TYPE_REFERENCE = "R";
    public static final String TYPE_UNKNOWN = "U";
    private static String[] opcodeNames = new String[]{"NOP", "ACONST_NULL", "ICONST_M1", "ICONST_0", "ICONST_1", "ICONST_2", "ICONST_3", "ICONST_4", "ICONST_5", "LCONST_0", "LCONST_1", "FCONST_0", "FCONST_1", "FCONST_2", "DCONST_0", "DCONST_1", "BIPUSH", "SIPUSH", "LDC", "LDC_W", "LDC2_W", "ILOAD", "LLOAD", "FLOAD", "DLOAD", "ALOAD", "ILOAD_0", "ILOAD_1", "ILOAD_2", "ILOAD_3", "LLOAD_0", "LLOAD_1", "LLOAD_2", "LLOAD_3", "FLOAD_0", "FLOAD_1", "FLOAD_2", "FLOAD_3", "DLOAD_0", "DLOAD_1", "DLOAD_2", "DLOAD_3", "ALOAD_0", "ALOAD_1", "ALOAD_2", "ALOAD_3", "IALOAD", "LALOAD", "FALOAD", "DALOAD", "AALOAD", "BALOAD", "CALOAD", "SALOAD", "ISTORE", "LSTORE", "FSTORE", "DSTORE", "ASTORE", "ISTORE_0", "ISTORE_1", "ISTORE_2", "ISTORE_3", "LSTORE_0", "LSTORE_1", "LSTORE_2", "LSTORE_3", "FSTORE_0", "FSTORE_1", "FSTORE_2", "FSTORE_3", "DSTORE_0", "DSTORE_1", "DSTORE_2", "DSTORE_3", "ASTORE_0", "ASTORE_1", "ASTORE_2", "ASTORE_3", "IASTORE", "LASTORE", "FASTORE", "DASTORE", "AASTORE", "BASTORE", "CASTORE", "SASTORE", "POP", "POP2", "DUP", "DUP_X1", "DUP_X2", "DUP2", "DUP2_X1", "DUP_X2", "SWAP", "IADD", "LADD", "FADD", "DADD", "ISUB", "LSUB", "FSUB", "DSUB", "IMUL", "LMUL", "FMUL", "DMUL", "IDIV", "LDIV", "FDIV", "DDIV", "IREM", "LREM", "FREM", "DREM", "INEG", "LNEG", "FNEG", "DNEG", "ISHL", "LSHL", "ISHR", "LSHR", "IUSHR", "LUSHR", "IAND", "LAND", "IOR", "LOR", "IXOR", "LXOR", "IINC", "I2L", "I2F", "I2D", "L2I", "L2F", "L2D", "F2I", "F2L", "F2D", "D2I", "D2L", "D2F", "I2B", "I2C", "I2S", "LCMP", "FCMPL", "FCMPG", "DCMPL", "DCMPG", "IFEQ", "IFNE", "IFLT", "IFGE", "IFGT", "IFLE", "IF_ICMPEQ", "IF_ICMPNE", "IF_ICMPLT", "IF_ICMPGE", "IF_ICMPGT", "IF_ICMPLE", "IF_ACMPEQ", "IF_ACMPNE", "GOTO", "JSR", "RET", "TABLESWITCH", "LOOKUPSWITCH", "IRETURN", "LRETURN", "FRETURN", "DRETURN", "ARETURN", "RETURN", "GETSTATIC", "PUTSTATIC", "GETFIELD", "PUTFIELD", "INVOKEVIRTUAL", "INVOKESPECIAL", "INVOKESTATIC", "INVOKEINTERFACE", "INVOKEDYNAMIC", "NEW", "NEWARRAY", "ANEWARRAY", "ARRAYLENGTH", "ATHROW", "CHECKCAST", "INSTANCEOF", "MONITORENTER", "MONITOREXIT", "WIDE", "MULTIANEWARRAY", "IFNULL", "IFNONNULL", "GOTO_W", "JSR_W"};

    static {
        assert (opcodeNames.length == 202);
    }

    public static int getVarIndex(AbstractInsnNode node) {
        if (node.getType() == 2) {
            return ((VarInsnNode)node).var;
        }
        if (node.getType() == 10) {
            return ((IincInsnNode)node).var;
        }
        assert (false) : "getVarIndex is called for an instruction without variable informaiton.";
        return -1;
    }

    public static boolean isAccess(AbstractInsnNode insn, LocalVariableNode var) {
        if (insn == null || var == null) {
            return false;
        }
        int varIndex = OpcodeString.getVarIndex(insn);
        if (var.index == varIndex) {
            Object scopeEndInstruction;
            if (OpcodeString.isStoreOperation(insn) || OpcodeString.isIncrementOperation(insn)) {
                if (var.start == insn.getNext()) {
                    return true;
                }
                scopeEndInstruction = var.start != var.end && var.end.getPrevious() != null && (OpcodeString.isStoreOperation(var.end.getPrevious()) || OpcodeString.isIncrementOperation(var.end.getPrevious())) ? var.end.getPrevious() : var.end;
            } else {
                assert (OpcodeString.isLoadOperation(insn) || OpcodeString.isRET(insn));
                scopeEndInstruction = var.end;
            }
            boolean inScope = false;
            LabelNode pos = var.start;
            while (pos != null && pos != scopeEndInstruction) {
                if (pos == insn) {
                    inScope = true;
                    break;
                }
                pos = pos.getNext();
            }
            return inScope;
        }
        return false;
    }

    public static LocalVariableNode findLocalVariable(MethodNode method, AbstractInsnNode insn) {
        if (method.localVariables == null) {
            return null;
        }
        List variables = method.localVariables;
        int i = 0;
        while (i < variables.size()) {
            LocalVariableNode var = (LocalVariableNode)variables.get(i);
            if (OpcodeString.isAccess(insn, var)) {
                return var;
            }
            ++i;
        }
        return null;
    }

    public static boolean isAfterJSR(AbstractInsnNode node) {
        if (node.getOpcode() != 25) {
            return false;
        }
        AbstractInsnNode n = node.getPrevious();
        if (n.getType() == 8) {
            n = n.getPrevious();
        }
        return n != null && n.getOpcode() == 168;
    }

    public static boolean isDefUseOperation(AbstractInsnNode node) {
        return OpcodeString.isStoreOperation(node) || OpcodeString.isLoadOperation(node) || OpcodeString.isIncrementOperation(node);
    }

    public static boolean isIncrementOperation(AbstractInsnNode node) {
        return node.getOpcode() == 132;
    }

    public static boolean isPrimitiveOperation(AbstractInsnNode node) {
        int opcode = node.getOpcode();
        return opcode == 54 || opcode == 56 || opcode == 55 || opcode == 57 || opcode == 21 || opcode == 23 || opcode == 22 || opcode == 24 || opcode == 132;
    }

    public static boolean isStoreOperation(AbstractInsnNode node) {
        int opcode = node.getOpcode();
        return opcode == 54 || opcode == 58 || opcode == 56 || opcode == 55 || opcode == 57;
    }

    public static boolean isRET(AbstractInsnNode node) {
        return node.getOpcode() == 169;
    }

    public static boolean isLocalReferenceOperation(AbstractInsnNode node) {
        return OpcodeString.isLoadOperation(node) || node.getOpcode() == 132;
    }

    public static boolean isLoadOperation(AbstractInsnNode node) {
        int opcode = node.getOpcode();
        return opcode == 21 || opcode == 25 || opcode == 23 || opcode == 22 || opcode == 24;
    }

    public static boolean isReturnOperation(AbstractInsnNode node) {
        int opcode = node.getOpcode();
        return opcode == 172 || opcode == 173 || opcode == 174 || opcode == 175 || opcode == 176 || opcode == 177;
    }

    public static boolean isConstantOperation(int opcode) {
        switch (opcode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return true;
            }
        }
        return false;
    }

    public static String getVariableString(LocalVariableNode node) {
        return String.valueOf(node.name) + ": " + TypeResolver.getTypeName(node.desc);
    }

    public static String getLabelString(MethodNode method, LabelNode label) {
        return OpcodeString.getLabelString(method, method.instructions.indexOf((AbstractInsnNode)label));
    }

    public static String getLabelString(MethodNode method, int index) {
        assert (method.instructions.get(index).getType() == 8);
        String right = "00000" + Integer.toString(index);
        return "L" + right.substring(right.length() - 5);
    }

    public static String getInstructionString(MethodNode method, int index) {
        if (index == -1) {
            return "ARG";
        }
        AbstractInsnNode node = method.instructions.get(index);
        int opcode = node.getOpcode();
        String op = String.valueOf(Integer.toString(index)) + ": " + OpcodeString.getString(opcode);
        switch (node.getType()) {
            case 2: 
            case 10: {
                LocalVariableNode n = OpcodeString.findLocalVariable(method, node);
                if (n != null) {
                    return String.valueOf(op) + " " + Integer.toString(n.index) + " (" + n.name + ")";
                }
                int varIndex = OpcodeString.getVarIndex(node);
                return String.valueOf(op) + " " + Integer.toString(varIndex);
            }
            case 4: {
                FieldInsnNode fieldNode = (FieldInsnNode)node;
                return String.valueOf(op) + " " + fieldNode.owner + "#" + fieldNode.name + ": " + TypeResolver.getTypeName(fieldNode.desc);
            }
            case 5: {
                MethodInsnNode methodInsnNode = (MethodInsnNode)node;
                return String.valueOf(op) + " " + methodInsnNode.owner + "#" + methodInsnNode.name + methodInsnNode.desc;
            }
            case 15: {
                LineNumberNode lineNode = (LineNumberNode)node;
                return String.valueOf(Integer.toString(index)) + ": " + "(line=" + lineNode.line + ")";
            }
            case 8: {
                return String.valueOf(Integer.toString(index)) + ": " + "(" + OpcodeString.getLabelString(method, index) + ")";
            }
            case 7: {
                JumpInsnNode jumpNode = (JumpInsnNode)node;
                return String.valueOf(op) + " " + OpcodeString.getLabelString(method, jumpNode.label);
            }
            case 14: {
                FrameNode frameNode = (FrameNode)node;
                return String.valueOf(Integer.toString(index)) + ": FRAME-OP(" + frameNode.type + ")";
            }
            case 9: {
                LdcInsnNode ldc = (LdcInsnNode)node;
                return String.valueOf(op) + " " + ldc.cst.toString();
            }
        }
        return op;
    }

    private static String getString(int opcode) {
        if (opcode >= 0 && opcode < opcodeNames.length) {
            return opcodeNames[opcode];
        }
        return Integer.toString(opcode);
    }
}

