/*
 * Decompiled with CFR 0.152.
 */
package soba.core.method.asm;

import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.analysis.Value;
import soba.core.method.asm.FastSourceInterpreter;
import soba.util.ObjectIdMap;

public class DataFlowInterpreter
extends FastSourceInterpreter {
    private ObjectIdMap<AbstractInsnNode> instructions;
    private int[] operands;

    public DataFlowInterpreter(ObjectIdMap<AbstractInsnNode> instructions) {
        super(instructions);
        this.instructions = instructions;
        this.operands = new int[instructions.size()];
    }

    public int getInstructionCount() {
        return this.instructions.size();
    }

    public int getOperandCount(int opIndex) {
        return this.operands[opIndex];
    }

    @Override
    public Value unaryOperation(AbstractInsnNode insn, Value value) {
        if (insn.getOpcode() == 132) {
            this.operands[this.instructions.getId((AbstractInsnNode)insn)] = 0;
            return super.unaryOperation(insn, value);
        }
        this.operands[this.instructions.getId((AbstractInsnNode)insn)] = 1;
        return super.unaryOperation(insn, value);
    }

    @Override
    public void returnOperation(AbstractInsnNode insn, Value value, Value expected) {
        this.operands[this.instructions.getId((AbstractInsnNode)insn)] = 1;
        super.returnOperation(insn, value, expected);
    }

    @Override
    public Value ternaryOperation(AbstractInsnNode insn, Value value1, Value value2, Value value3) {
        this.operands[this.instructions.getId((AbstractInsnNode)insn)] = 3;
        return super.ternaryOperation(insn, value1, value2, value3);
    }

    @Override
    public Value binaryOperation(AbstractInsnNode insn, Value value1, Value value2) {
        this.operands[this.instructions.getId((AbstractInsnNode)insn)] = 2;
        return super.binaryOperation(insn, value1, value2);
    }

    @Override
    public Value copyOperation(AbstractInsnNode insn, Value value) {
        int operandCount = 0;
        switch (insn.getOpcode()) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                operandCount = 0;
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                operandCount = 1;
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                return value;
            }
        }
        this.operands[this.instructions.getId((AbstractInsnNode)insn)] = operandCount;
        return super.copyOperation(insn, value);
    }

    @Override
    public Value newValue(Type type) {
        return super.newValue(type);
    }

    @Override
    public Value newOperation(AbstractInsnNode insn) {
        return super.newOperation(insn);
    }

    @Override
    public Value naryOperation(AbstractInsnNode insn, List<? extends Value> values) {
        this.operands[this.instructions.getId((AbstractInsnNode)insn)] = values.size();
        return super.naryOperation(insn, values);
    }
}

