/*
 * Decompiled with CFR 0.152.
 */
package soba.core.method.asm;

import java.util.List;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;
import soba.core.method.asm.FastSourceValue;
import soba.util.ObjectIdMap;

public class FastSourceInterpreter
extends Interpreter<Value>
implements Opcodes {
    public static final int METHOD_ENTRY = -1;
    private ObjectIdMap<AbstractInsnNode> instructions;

    public FastSourceInterpreter(ObjectIdMap<AbstractInsnNode> instructions) {
        super(327680);
        this.instructions = instructions;
    }

    public Value newValue(Type type) {
        if (type == null) {
            return new FastSourceValue(1);
        }
        if (type == Type.VOID_TYPE) {
            return null;
        }
        return new FastSourceValue(type.getSize(), -1);
    }

    public Value newOperation(AbstractInsnNode insn) {
        int size;
        switch (insn.getOpcode()) {
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                size = 2;
                break;
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                size = cst instanceof Long || cst instanceof Double ? 2 : 1;
                break;
            }
            case 178: {
                size = Type.getType((String)((FieldInsnNode)insn).desc).getSize();
                break;
            }
            default: {
                size = 1;
            }
        }
        return new FastSourceValue(size, this.instructions.getId(insn));
    }

    public Value copyOperation(AbstractInsnNode insn, Value value) {
        return new FastSourceValue(value.getSize(), this.instructions.getId(insn));
    }

    public Value unaryOperation(AbstractInsnNode insn, Value value) {
        int size;
        switch (insn.getOpcode()) {
            case 117: 
            case 119: 
            case 133: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: {
                size = 2;
                break;
            }
            case 180: {
                size = Type.getType((String)((FieldInsnNode)insn).desc).getSize();
                break;
            }
            default: {
                size = 1;
            }
        }
        return new FastSourceValue(size, this.instructions.getId(insn));
    }

    public Value binaryOperation(AbstractInsnNode insn, Value value1, Value value2) {
        int size;
        switch (insn.getOpcode()) {
            case 47: 
            case 49: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                size = 2;
                break;
            }
            default: {
                size = 1;
            }
        }
        return new FastSourceValue(size, this.instructions.getId(insn));
    }

    public Value ternaryOperation(AbstractInsnNode insn, Value value1, Value value2, Value value3) {
        return new FastSourceValue(1, this.instructions.getId(insn));
    }

    public Value naryOperation(AbstractInsnNode insn, List<? extends Value> values) {
        int size = insn.getOpcode() == 197 ? 1 : (insn.getOpcode() == 186 ? Type.getReturnType((String)((InvokeDynamicInsnNode)insn).desc).getSize() : Type.getReturnType((String)((MethodInsnNode)insn).desc).getSize());
        return new FastSourceValue(size, this.instructions.getId(insn));
    }

    public void returnOperation(AbstractInsnNode insn, Value value, Value expected) {
    }

    public Value merge(Value v, Value w) {
        if (v == w) {
            return v;
        }
        FastSourceValue dv = (FastSourceValue)v;
        FastSourceValue dw = (FastSourceValue)w;
        if (dv.getSize() == dw.getSize() && dv.containsAll(dw)) {
            return v;
        }
        return new FastSourceValue(dv, dw);
    }
}

