/*
 * Decompiled with CFR 0.152.
 */
package soba.core.method.asm;

import gnu.trove.list.array.TIntArrayList;
import java.util.Arrays;
import org.objectweb.asm.tree.analysis.Value;

public class FastSourceValue
implements Value {
    private final int size;
    private int[] instructions;
    private static int[] EMPTY_ARRAY = new int[0];

    public FastSourceValue(int size) {
        this.size = size;
        this.instructions = EMPTY_ARRAY;
    }

    public FastSourceValue(int size, int instructionIndex) {
        this.size = size;
        this.instructions = new int[]{instructionIndex};
    }

    public FastSourceValue(int size, int[] instructionIndices) {
        this.size = size;
        this.instructions = instructionIndices;
    }

    public int getSize() {
        return this.size;
    }

    public int[] getInstructions() {
        return this.instructions;
    }

    public FastSourceValue(FastSourceValue base1, FastSourceValue base2) {
        this.size = Math.min(base1.size, base2.size);
        TIntArrayList list = new TIntArrayList(base1.instructions.length + base2.instructions.length);
        int index1 = 0;
        int index2 = 0;
        while (index1 < base1.instructions.length && index2 < base2.instructions.length) {
            int v1 = base1.instructions[index1];
            int v2 = base2.instructions[index2];
            if (v1 == v2) {
                list.add(v1);
                ++index1;
                ++index2;
                continue;
            }
            if (v1 < v2) {
                list.add(v1);
                ++index1;
                continue;
            }
            list.add(v2);
            ++index2;
        }
        while (index1 < base1.instructions.length) {
            list.add(base1.instructions[index1]);
            ++index1;
        }
        while (index2 < base2.instructions.length) {
            list.add(base2.instructions[index2]);
            ++index2;
        }
        this.instructions = list.toArray();
    }

    public boolean containsAll(FastSourceValue another) {
        int thisIndex = 0;
        int anotherIndex = 0;
        while (anotherIndex < another.instructions.length) {
            if (thisIndex < this.instructions.length) {
                int thisValue = this.instructions[thisIndex];
                int anotherValue = another.instructions[anotherIndex];
                if (thisValue > anotherValue) {
                    return false;
                }
                if (thisValue == anotherValue) {
                    ++thisIndex;
                    ++anotherIndex;
                    continue;
                }
                ++thisIndex;
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object another) {
        if (another instanceof FastSourceValue) {
            FastSourceValue v = (FastSourceValue)another;
            return this.size == v.size && Arrays.equals(this.instructions, v.instructions);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.instructions);
    }
}

