/*
 * Decompiled with CFR 0.152.
 */
package soba.core.signature;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.signature.SignatureVisitor;

public class TypeVisitor
extends SignatureVisitor {
    private int arrayDimension = 0;
    private String typename = null;
    private boolean generictype = false;
    private List<TypeVisitor> typeArguments = null;
    private List<String> innerTypeNames = null;
    private List<List<TypeVisitor>> innerTypeArguments = null;
    private boolean parsingInner = false;

    public TypeVisitor() {
        super(327680);
    }

    public String getTypeName() {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append(this.typename);
        if (this.typeArguments != null) {
            buf.append("<");
            i = 0;
            while (i < this.typeArguments.size()) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(this.typeArguments.get(i).getTypeName());
                ++i;
            }
            buf.append(">");
        }
        if (this.innerTypeNames != null) {
            i = 0;
            while (i < this.innerTypeNames.size()) {
                buf.append(".");
                buf.append(this.innerTypeNames.get(i));
                List<TypeVisitor> arguments = this.innerTypeArguments.get(i);
                if (arguments.size() > 0) {
                    buf.append("<");
                    int innerArg = 0;
                    while (innerArg < arguments.size()) {
                        if (innerArg > 0) {
                            buf.append(",");
                        }
                        buf.append(arguments.get(innerArg).getTypeName());
                        ++innerArg;
                    }
                    buf.append(">");
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.arrayDimension) {
            buf.append("[]");
            ++i;
        }
        return buf.toString();
    }

    public boolean isGenericType() {
        return this.generictype;
    }

    public void visitBaseType(char descriptor) {
        switch (descriptor) {
            case 'Z': {
                this.typename = "boolean";
                break;
            }
            case 'B': {
                this.typename = "byte";
                break;
            }
            case 'C': {
                this.typename = "char";
                break;
            }
            case 'S': {
                this.typename = "short";
                break;
            }
            case 'I': {
                this.typename = "int";
                break;
            }
            case 'J': {
                this.typename = "long";
                break;
            }
            case 'F': {
                this.typename = "float";
                break;
            }
            case 'D': {
                this.typename = "double";
                break;
            }
            case 'V': {
                this.typename = "void";
                break;
            }
            default: {
                this.typename = Character.toString(descriptor);
            }
        }
    }

    public void visitTypeVariable(String name) {
        this.typename = name;
        this.generictype = true;
    }

    public SignatureVisitor visitArrayType() {
        ++this.arrayDimension;
        return this;
    }

    public void visitClassType(String name) {
        this.typename = name;
    }

    private TypeVisitor createTypeArgumentVisitor() {
        TypeVisitor argument = new TypeVisitor();
        if (this.parsingInner) {
            int size = this.innerTypeArguments.size();
            this.innerTypeArguments.get(size - 1).add(argument);
        } else {
            if (this.typeArguments == null) {
                this.typeArguments = new ArrayList<TypeVisitor>();
            }
            this.typeArguments.add(argument);
        }
        return argument;
    }

    public void visitTypeArgument() {
        TypeVisitor argument = this.createTypeArgumentVisitor();
        argument.typename = "?";
        argument.generictype = true;
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        TypeVisitor argument = this.createTypeArgumentVisitor();
        return argument;
    }

    public void visitInnerClassType(String name) {
        this.parsingInner = true;
        if (this.innerTypeNames == null) {
            this.innerTypeNames = new ArrayList<String>();
            this.innerTypeArguments = new ArrayList<List<TypeVisitor>>();
        }
        this.innerTypeNames.add(name);
        this.innerTypeArguments.add(new ArrayList());
    }

    public void visitEnd() {
    }

    public SignatureVisitor visitInterface() {
        assert (false) : "This method never used for parsing a type.";
        return null;
    }

    public SignatureVisitor visitInterfaceBound() {
        assert (false) : "This method never used for parsing a type.";
        return null;
    }

    public SignatureVisitor visitClassBound() {
        assert (false) : "This method never used for parsing a type.";
        return null;
    }

    public SignatureVisitor visitExceptionType() {
        assert (false) : "This method never used for parsing a type.";
        return null;
    }

    public void visitFormalTypeParameter(String name) {
        assert (false) : "This method never used for parsing a type.";
    }

    public SignatureVisitor visitParameterType() {
        assert (false) : "This method never used for parsing a type.";
        return null;
    }

    public SignatureVisitor visitReturnType() {
        assert (false) : "This method never used for parsing a type.";
        return null;
    }

    public SignatureVisitor visitSuperclass() {
        assert (false) : "This method never used for parsing a type.";
        return null;
    }
}

