/*
 * Decompiled with CFR 0.152.
 */
package soba.core.vta;

import soba.core.ClassHierarchy;
import soba.core.IDynamicBindingResolver;
import soba.core.JavaProgram;
import soba.core.MethodInfo;
import soba.core.method.CallSite;
import soba.core.vta.IAnalysisTarget;
import soba.core.vta.VTAResolver;

public abstract class CallResolver
implements IDynamicBindingResolver {
    public static CallResolver getCHA(JavaProgram program) {
        return new CHA(program.getClassHierarchy());
    }

    public static CallResolver getCHA(ClassHierarchy hierarchy) {
        return new CHA(hierarchy);
    }

    public static CallResolver getVTA(JavaProgram program, IAnalysisTarget selector) {
        VTAResolver vta = new VTAResolver(program, selector);
        return new VTA(program.getClassHierarchy(), vta);
    }

    public static CallResolver getVTA(JavaProgram program) {
        VTAResolver vta = new VTAResolver(program);
        return new VTA(program.getClassHierarchy(), vta);
    }

    @Override
    public abstract MethodInfo[] resolveCall(CallSite var1);

    private static class CHA
    extends CallResolver {
        private ClassHierarchy ch;

        public CHA(ClassHierarchy ch) {
            this.ch = ch;
        }

        @Override
        public MethodInfo[] resolveCall(CallSite c) {
            return this.ch.resolveCall(c);
        }
    }

    private static class VTA
    extends CallResolver {
        private ClassHierarchy ch;
        private VTAResolver vta;

        public VTA(ClassHierarchy ch, VTAResolver vta) {
            this.ch = ch;
            this.vta = vta;
        }

        @Override
        public MethodInfo[] resolveCall(CallSite c) {
            if (c.isStaticOrSpecial()) {
                return this.ch.resolveCall(c);
            }
            return this.vta.resolveCall(c);
        }
    }
}

