/*
 * Decompiled with CFR 0.152.
 */
package soba.core.vta;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import soba.core.ClassInfo;
import soba.core.JavaProgram;
import soba.core.JavaProgramTest;
import soba.core.MethodInfo;
import soba.core.method.CallSite;
import soba.core.vta.CallSiteVertices;

public class CallSiteVerticesTest {
    private static JavaProgram program;
    private static MethodInfo m;
    private static CallSiteVertices v;
    private static final int startID = 1;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        program = JavaProgramTest.readExampleProgram();
        ClassInfo c = program.getClassInfo("soba/testdata/ObjectTransferCode");
        m = c.findMethod("newObject", "(I)[[I");
        CallSite callSite = null;
        int i = 0;
        while (i < m.getInstructionCount()) {
            CallSite cs = m.getCallSite(i);
            if (cs != null && cs.getMethodName().equals("m2")) {
                callSite = cs;
                break;
            }
            ++i;
        }
        v = new CallSiteVertices(callSite, 1);
    }

    @Test
    public void testIsObjectParam() {
        Assert.assertThat((Object)v.isObjectParam(0), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)v.isObjectParam(1), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGetParamVertexId() {
        Assert.assertThat((Object)v.getParamVertexId(0), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)v.getParamVertexId(1), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testGetParamCount() {
        Assert.assertThat((Object)v.getParamCount(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testHasReturnValue() {
        Assert.assertThat((Object)v.hasReturnValue(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGetReturnValueVertex() {
        Assert.assertThat((Object)v.getReturnValueVertex(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void testGetVertexCount() {
        Assert.assertThat((Object)v.getVertexCount(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void testGetVertex() {
        Assert.assertThat((Object)v.getVertex(0), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)v.getVertex(1), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)v.getVertex(2), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void testGetTypeName() {
        Assert.assertThat((Object)v.getTypeName(0), (Matcher)Matchers.is((Object)"soba/testdata/ObjectTransferCode"));
        Assert.assertThat((Object)v.getTypeName(1), (Matcher)Matchers.is((Object)"soba/testdata/ObjectTransferCode1"));
    }

    @Test
    public void testGetReturnValueTypeName() {
        Assert.assertThat((Object)v.getReturnValueTypeName(), (Matcher)Matchers.is((Object)"soba/testdata/ObjectTransferCode"));
    }
}

