/*
 * Decompiled with CFR 0.152.
 */
package soba.core.vta;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.objectweb.asm.tree.InsnList;
import soba.core.ClassInfo;
import soba.core.JavaProgram;
import soba.core.JavaProgramTest;
import soba.core.MethodInfo;
import soba.core.vta.NewVertices;
import soba.core.vta.VTAResolver;

public class NewVerticesTest {
    private static JavaProgram program;
    private static MethodInfo m;
    private static NewVertices v;
    private static final int startID = 1;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        program = JavaProgramTest.readExampleProgram();
        ClassInfo c = program.getClassInfo("soba/testdata/ObjectTransferCode");
        m = c.findMethod("newObject", "(I)[[I");
        v = new NewVertices(NewVerticesTest.m.getMethodNode().instructions, 1);
    }

    @Test
    public void testGetNewInstructionVertex() {
        int count = 1;
        InsnList instructions = NewVerticesTest.m.getMethodNode().instructions;
        int i = 0;
        while (i < instructions.size()) {
            switch (instructions.get(i).getOpcode()) {
                case 187: 
                case 189: 
                case 197: {
                    Assert.assertThat((Object)v.getNewInstructionVertex(i), (Matcher)Matchers.is((Object)count));
                    ++count;
                    break;
                }
                default: {
                    Assert.assertThat((Object)v.getNewInstructionVertex(i), (Matcher)Matchers.is((Object)VTAResolver.VERTEX_ERROR));
                }
            }
            ++i;
        }
    }

    @Test
    public void testGetVertex() {
        Assert.assertThat((Object)v.getVertex(0), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)v.getVertex(1), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)v.getVertex(2), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void testGetTypeName() {
        Assert.assertThat((Object)v.getTypeName(0), (Matcher)Matchers.is((Object)"soba/testdata/ObjectTransferCode"));
        Assert.assertThat((Object)v.getTypeName(1), (Matcher)Matchers.is((Object)"soba/testdata/ObjectTransferCode[]"));
        Assert.assertThat((Object)v.getTypeName(2), (Matcher)Matchers.is((Object)"int[][]"));
    }

    @Test
    public void testGetVertexCount() {
        Assert.assertThat((Object)v.getVertexCount(), (Matcher)Matchers.is((Object)3));
    }
}

