/*
 * Decompiled with CFR 0.152.
 */
package soba.core.vta;

import soba.core.vta.ITopologicalVisitor;
import soba.util.graph.DirectedAcyclicGraph;

public class TopologicalOrderSearch {
    public static void searchFromRoot(DirectedAcyclicGraph graph, ITopologicalVisitor visit) {
        int[] incoming = new int[graph.getVertexCount()];
        int i = 0;
        while (i < graph.getVertexCount()) {
            int[] nArray = graph.getEdges(i);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int to;
                int n3 = to = nArray[n2];
                incoming[n3] = incoming[n3] + 1;
                ++n2;
            }
            ++i;
        }
        int[] queue = new int[graph.getVertexCount()];
        int queueEndIndex = 0;
        int i2 = 0;
        while (i2 < graph.getVertexCount()) {
            if (incoming[i2] == 0 && graph.isRepresentativeNode(i2)) {
                queue[queueEndIndex] = i2;
                ++queueEndIndex;
            }
            ++i2;
        }
        int queueIndex = 0;
        while (queueIndex < queueEndIndex) {
            int v = queue[queueIndex];
            ++queueIndex;
            boolean continueVisit = visit.onVisit(v);
            if (!continueVisit) continue;
            int[] nArray = graph.getEdges(v);
            int n = nArray.length;
            int n4 = 0;
            while (n4 < n) {
                int to;
                int n5 = to = nArray[n4];
                incoming[n5] = incoming[n5] - 1;
                if (incoming[to] == 0) {
                    queue[queueEndIndex] = to;
                    ++queueEndIndex;
                }
                ++n4;
            }
        }
        visit.onFinished();
    }
}

