/*
 * Decompiled with CFR 0.152.
 */
package soba.core.vta;

import java.util.List;
import soba.core.vta.TypeSetManager;

public class TypeSet {
    public static final String DEFAULT_UNKNOWN_TYPE = "java/lang/Object";
    public static final String DEFAULT_UNKNOWN_ARRAYTYPE = "java/lang/Object[]";
    private TypeSetManager manager;
    private int typesId;
    private int approximatedTypesId;

    public TypeSet(TypeSetManager manager) {
        this.manager = manager;
        this.typesId = manager.getEmptyId();
        this.approximatedTypesId = manager.getEmptyId();
    }

    public TypeSet(TypeSetManager manager, String typename) {
        this.manager = manager;
        assert (typename != null);
        this.typesId = manager.getId(typename);
        this.approximatedTypesId = manager.getEmptyId();
    }

    public TypeSet(TypeSetManager manager, List<TypeSet> parents) {
        this.manager = manager;
        if (parents.size() == 0) {
            this.typesId = manager.getEmptyId();
            this.approximatedTypesId = manager.getEmptyId();
        } else if (parents.size() == 1) {
            this.typesId = parents.get((int)0).typesId;
            this.approximatedTypesId = parents.get((int)0).approximatedTypesId;
        } else {
            int mergeTypesId = parents.get((int)0).typesId;
            int mergeAppoximatedTypesId = parents.get((int)0).approximatedTypesId;
            int i = 1;
            while (i < parents.size()) {
                mergeTypesId = manager.merge(mergeTypesId, parents.get((int)i).typesId);
                mergeAppoximatedTypesId = manager.merge(mergeAppoximatedTypesId, parents.get((int)i).approximatedTypesId);
                ++i;
            }
            this.typesId = mergeTypesId;
            this.approximatedTypesId = mergeAppoximatedTypesId;
        }
    }

    public TypeSet addType(String additionalType) {
        TypeSet copy = new TypeSet(this.manager);
        copy.typesId = this.manager.merge(this.typesId, this.manager.getId(additionalType));
        copy.approximatedTypesId = this.approximatedTypesId;
        return copy;
    }

    public static TypeSet createApproximation(TypeSetManager manager, String typename) {
        TypeSet t = new TypeSet(manager);
        t.approximatedTypesId = manager.getId(typename);
        return t;
    }

    public TypeSet addApproximatedType(String additionalType) {
        TypeSet copy = new TypeSet(this.manager);
        copy.typesId = this.typesId;
        copy.approximatedTypesId = this.manager.merge(this.approximatedTypesId, this.manager.getId(additionalType));
        return copy;
    }

    public boolean contains(String t) {
        if (t == null) {
            return false;
        }
        String[] types = this.manager.getStrings(this.typesId);
        int i = 0;
        while (i < types.length) {
            if (t.equals(types[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getTypeCount() {
        return this.manager.getStrings(this.typesId).length;
    }

    public String getType(int index) {
        return this.manager.getStrings(this.typesId)[index];
    }

    public int getApproximatedTypeCount() {
        return this.manager.getStrings(this.approximatedTypesId).length;
    }

    public String getApproximatedType(int index) {
        return this.manager.getStrings(this.approximatedTypesId)[index];
    }
}

