/*
 * Decompiled with CFR 0.152.
 */
package soba.core.vta;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Arrays;
import java.util.HashSet;
import soba.util.ObjectIdMap;

public class TypeSetManager {
    private ObjectIdMap<String> cache = new ObjectIdMap();
    private TIntObjectHashMap<String[]> strings = new TIntObjectHashMap();
    private static final String[] EMPTY = new String[0];
    private static final String SEPARATOR = "|";
    private static final String SEPARATOR_REGEX = "\\|";
    private TIntObjectHashMap<TIntIntHashMap> mergeMap;

    public TypeSetManager() {
        this.cache.add("");
        this.mergeMap = new TIntObjectHashMap();
    }

    public int getEmptyId() {
        return this.cache.getId("");
    }

    public int getId(String singleString) {
        return this.cache.getId(singleString);
    }

    public int getId(String[] strings) {
        return this.cache.getId(this.toSingleString(strings));
    }

    public String[] getStrings(int id) {
        if (this.strings.containsKey(id)) {
            return (String[])this.strings.get(id);
        }
        String s = this.cache.getItem(id);
        if (s.length() == 0) {
            return EMPTY;
        }
        String[] array = s.split(SEPARATOR_REGEX);
        this.strings.put(id, (Object)array);
        return array;
    }

    public int merge(int id1, int id2) {
        String s;
        TIntIntHashMap map;
        if (id1 > id2) {
            int swap = id1;
            id1 = id2;
            id2 = swap;
        }
        if ((map = (TIntIntHashMap)this.mergeMap.get(id1)) != null && map.containsKey(id2)) {
            return map.get(id2);
        }
        HashSet<String> union = new HashSet<String>();
        String[] stringArray = this.getStrings(id1);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            union.add(s);
            ++n2;
        }
        stringArray = this.getStrings(id2);
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            union.add(s);
            ++n2;
        }
        Object[] unionStrings = union.toArray(EMPTY);
        Arrays.sort(unionStrings);
        int result = this.getId((String[])unionStrings);
        if (map == null) {
            map = new TIntIntHashMap();
            this.mergeMap.put(id1, (Object)map);
        }
        map.put(id2, result);
        return result;
    }

    private String toSingleString(String[] types) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                b.append(SEPARATOR);
            }
            b.append(types[i]);
            ++i;
        }
        return b.toString();
    }

    public int size() {
        int total = 0;
        int i = 0;
        while (i < this.cache.size()) {
            total += this.cache.getItem(i).length();
            ++i;
        }
        return total;
    }
}

