/*
 * Decompiled with CFR 0.152.
 */
package soba.util;

import java.util.Arrays;
import soba.util.IntPairProc;

public class IntPairList {
    private int count;
    private long[] values;
    private boolean frozen;

    public IntPairList() {
        this(1024);
    }

    public IntPairList(int capacity) {
        this.values = new long[capacity];
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    private long compose(int elem1, int elem2) {
        return (long)elem1 << 32 | (long)elem2;
    }

    public int getFirstValue(int index) {
        if (index < 0 || index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (int)(this.values[index] >> 32);
    }

    public int getSecondValue(int index) {
        if (index < 0 || index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (int)(this.values[index] & 0xFFFFFFFFFFFFFFFFL);
    }

    public void add(int elem1, int elem2) {
        if (!this.frozen) {
            if (this.values.length == this.count) {
                this.growUp();
            }
            this.values[this.count] = this.compose(elem1, elem2);
            ++this.count;
        } else {
            throw new FrozenListException();
        }
    }

    public void addAll(IntPairList another) {
        if (!this.frozen) {
            int anotherSize = another.size();
            int i = 0;
            while (i < anotherSize) {
                if (this.values.length == this.count) {
                    this.growUp();
                }
                this.values[this.count] = another.values[i];
                ++this.count;
                ++i;
            }
        } else {
            throw new FrozenListException();
        }
    }

    private void growUp() {
        long[] newValues = new long[this.values.length * 2];
        int i = 0;
        while (i < this.count) {
            newValues[i] = this.values[i];
            ++i;
        }
        this.values = newValues;
    }

    public void setFirstValue(int index, int first) {
        if (!this.frozen) {
            if (index < 0 || this.count <= index) {
                throw new ArrayIndexOutOfBoundsException();
            }
        } else {
            throw new FrozenListException();
        }
        int second = this.getSecondValue(index);
        this.values[index] = this.compose(first, second);
    }

    public void setSecondValue(int index, int second) {
        if (!this.frozen) {
            if (index < 0 || this.count <= index) {
                throw new ArrayIndexOutOfBoundsException();
            }
        } else {
            throw new FrozenListException();
        }
        int first = this.getFirstValue(index);
        this.values[index] = this.compose(first, second);
    }

    public void sort() {
        Arrays.sort(this.values, 0, this.count);
    }

    public void foreach(IntPairProc proc) {
        boolean cont = true;
        int i = 0;
        while (cont && i < this.count) {
            cont = proc.execute(this.getFirstValue(i), this.getSecondValue(i));
            ++i;
        }
    }

    public void freeze() {
        this.frozen = true;
    }

    public static class FrozenListException
    extends RuntimeException {
        private static final long serialVersionUID = 1519361503126979153L;
    }
}

