/*
 * Decompiled with CFR 0.152.
 */
package soba.util;

import soba.util.IntStack;

public class IntSetStack
extends IntStack {
    private int max;
    private static final int DIV = 31;
    private int[] elements;
    private boolean ignoreDuplicatedElement;

    private static int elementIndex(int value) {
        return value / 31;
    }

    private static int bitMask(int value) {
        int b = value % 31;
        return 1 << b;
    }

    public IntSetStack(int maxValue) {
        this.max = maxValue;
        this.elements = new int[IntSetStack.elementIndex(maxValue) + 1];
    }

    public IntSetStack(int maxValue, int capacity) {
        super(capacity);
        this.elements = new int[IntSetStack.elementIndex(maxValue) + 1];
    }

    public void setIgnoreDuplicatedElement(boolean ignore) {
        this.ignoreDuplicatedElement = ignore;
    }

    @Override
    public boolean contains(int value) {
        int bit = this.elements[IntSetStack.elementIndex(value)];
        return (bit & IntSetStack.bitMask(value)) != 0;
    }

    @Override
    public void push(int value) {
        int bitMask;
        if (this.max < value) {
            throw new InvalidElementException(this.max, value);
        }
        int index = IntSetStack.elementIndex(value);
        int bit = this.elements[index];
        if ((bit & (bitMask = IntSetStack.bitMask(value))) == 0) {
            super.push(value);
            int n = index;
            this.elements[n] = this.elements[n] | bitMask;
        } else if (!this.ignoreDuplicatedElement) {
            throw new DuplicatedElementException();
        }
        assert ((this.elements[index] & bitMask) != 0);
    }

    @Override
    public int pop() {
        int value = super.pop();
        int index = IntSetStack.elementIndex(value);
        int bitMask = IntSetStack.bitMask(value);
        int n = index;
        this.elements[n] = this.elements[n] ^ bitMask;
        assert ((this.elements[index] & bitMask) == 0);
        return value;
    }

    public class DuplicatedElementException
    extends RuntimeException {
        private static final long serialVersionUID = -3896583429225358307L;
    }

    public class InvalidElementException
    extends RuntimeException {
        private static final long serialVersionUID = -8544940855615952576L;
        private int max;
        private int value;

        public InvalidElementException(int max, int value) {
            this.max = max;
            this.value = value;
        }

        @Override
        public String getMessage() {
            return "The given value cannot be stored into the stack. MAX=" + Integer.toString(this.max) + ", VALUE=" + Integer.toString(this.value);
        }

        public int getValue() {
            return this.value;
        }

        public int getMax() {
            return this.max;
        }
    }
}

