/*
 * Decompiled with CFR 0.152.
 */
package soba.util;

import java.util.EmptyStackException;
import org.junit.Assert;
import org.junit.Test;
import soba.util.IntSetStack;

public class IntSetStackTest {
    @Test
    public void testStack() throws Exception {
        IntSetStack stack = new IntSetStack(3);
        Assert.assertTrue((boolean)stack.isEmpty());
        Assert.assertFalse((boolean)stack.contains(0));
        Assert.assertFalse((boolean)stack.contains(1));
        Assert.assertFalse((boolean)stack.contains(2));
        stack.push(0);
        Assert.assertEquals((long)0L, (long)stack.peek());
        Assert.assertFalse((boolean)stack.isEmpty());
        Assert.assertTrue((boolean)stack.contains(0));
        Assert.assertFalse((boolean)stack.contains(1));
        Assert.assertFalse((boolean)stack.contains(2));
        stack.push(1);
        Assert.assertEquals((long)1L, (long)stack.peek());
        Assert.assertFalse((boolean)stack.isEmpty());
        Assert.assertTrue((boolean)stack.contains(0));
        Assert.assertTrue((boolean)stack.contains(1));
        Assert.assertFalse((boolean)stack.contains(2));
        stack.push(2);
        Assert.assertEquals((long)2L, (long)stack.peek());
        Assert.assertFalse((boolean)stack.isEmpty());
        Assert.assertTrue((boolean)stack.contains(0));
        Assert.assertTrue((boolean)stack.contains(1));
        Assert.assertTrue((boolean)stack.contains(2));
        Assert.assertEquals((long)2L, (long)stack.pop());
        Assert.assertEquals((long)1L, (long)stack.peek());
        Assert.assertTrue((boolean)stack.contains(0));
        Assert.assertTrue((boolean)stack.contains(1));
        Assert.assertFalse((boolean)stack.contains(2));
        Assert.assertEquals((long)1L, (long)stack.pop());
        Assert.assertEquals((long)0L, (long)stack.pop());
        Assert.assertTrue((boolean)stack.isEmpty());
        Assert.assertFalse((boolean)stack.contains(0));
        Assert.assertFalse((boolean)stack.contains(1));
        Assert.assertFalse((boolean)stack.contains(2));
        try {
            stack.pop();
            Assert.fail();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        try {
            stack.peek();
            Assert.fail();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    @Test
    public void testStackContains() {
        IntSetStack stack = new IntSetStack(128);
        try {
            stack.push(64);
            stack.push(96);
            stack.push(127);
            stack.push(128);
            stack.push(129);
            Assert.fail();
        }
        catch (IntSetStack.InvalidElementException e) {
            Assert.assertEquals((long)129L, (long)e.getValue());
        }
        Assert.assertTrue((boolean)stack.contains(64));
        Assert.assertTrue((boolean)stack.contains(96));
        Assert.assertTrue((boolean)stack.contains(127));
        Assert.assertTrue((boolean)stack.contains(128));
        Assert.assertFalse((boolean)stack.contains(63));
        Assert.assertFalse((boolean)stack.contains(65));
        Assert.assertFalse((boolean)stack.contains(95));
        Assert.assertFalse((boolean)stack.contains(97));
        Assert.assertFalse((boolean)stack.contains(126));
        try {
            stack.push(64);
            Assert.fail();
        }
        catch (IntSetStack.DuplicatedElementException duplicatedElementException) {
            // empty catch block
        }
    }

    @Test
    public void testStackIgnoreDuplicatedElement() {
        IntSetStack stack = new IntSetStack(8);
        stack.setIgnoreDuplicatedElement(true);
        stack.push(1);
        stack.push(2);
        stack.push(3);
        stack.push(4);
        stack.push(2);
        stack.push(4);
        stack.push(1);
        stack.push(3);
        stack.push(0);
        Assert.assertEquals((long)0L, (long)stack.pop());
        Assert.assertEquals((long)4L, (long)stack.pop());
        Assert.assertEquals((long)3L, (long)stack.pop());
        Assert.assertEquals((long)2L, (long)stack.pop());
        Assert.assertEquals((long)1L, (long)stack.pop());
        Assert.assertTrue((boolean)stack.isEmpty());
        stack.push(1);
        stack.push(2);
        stack.push(3);
        stack.push(4);
        Assert.assertEquals((long)4L, (long)stack.pop());
        Assert.assertEquals((long)3L, (long)stack.pop());
        Assert.assertEquals((long)2L, (long)stack.pop());
        Assert.assertEquals((long)1L, (long)stack.pop());
        Assert.assertTrue((boolean)stack.isEmpty());
    }
}

