/*
 * Decompiled with CFR 0.152.
 */
package soba.util;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;

public class ObjectIdMap<T> {
    private TObjectIntHashMap<T> map;
    private ArrayList<T> idToObject;
    private boolean frozen;

    public ObjectIdMap() {
        this(0x100000);
    }

    public ObjectIdMap(int capacity) {
        this.map = new TObjectIntHashMap(capacity * 2);
        this.idToObject = new ArrayList(capacity);
        this.frozen = false;
    }

    public void freeze() {
        this.frozen = true;
    }

    public void add(T s) {
        this.getId(s);
    }

    public int getId(T item) {
        if (this.map.containsKey(item)) {
            return this.map.get(item);
        }
        if (this.frozen) {
            throw new FrozenMapException();
        }
        int newId = this.idToObject.size();
        this.map.put(item, newId);
        this.idToObject.add(item);
        return newId;
    }

    public T getItem(int id) {
        if (id < 0 || id >= this.idToObject.size()) {
            return null;
        }
        return this.idToObject.get(id);
    }

    public int size() {
        return this.idToObject.size();
    }

    public static class FrozenMapException
    extends RuntimeException {
        private static final long serialVersionUID = -1682458461699095201L;
    }
}

