/*
 * Decompiled with CFR 0.152.
 */
package soba.util;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import soba.util.ObjectIdMap;

public class ObjectIdMapTest {
    @Test
    public void testObjectIdMap() {
        ObjectIdMap<String> idMap = new ObjectIdMap<String>();
        int idABC = idMap.getId("abc");
        int idAB = idMap.getId("ab");
        int idABC2 = idMap.getId("abc");
        int idD = idMap.getId("d");
        Assert.assertThat((Object)idMap.size(), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)idABC, (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)idABC2, (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)idAB, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)idD, (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)((String)idMap.getItem(idABC)), (Matcher)Matchers.is((Object)"abc"));
        Assert.assertThat((Object)((String)idMap.getItem(idAB)), (Matcher)Matchers.is((Object)"ab"));
        Assert.assertThat((Object)((String)idMap.getItem(idD)), (Matcher)Matchers.is((Object)"d"));
        Assert.assertThat((Object)((String)idMap.getItem(-1)), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)((String)idMap.getItem(4)), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testAdd() {
        ObjectIdMap<String> idMap = new ObjectIdMap<String>();
        idMap.add("abc");
        idMap.add("ab");
        idMap.add("ab");
        idMap.add("abc");
        Assert.assertThat((Object)idMap.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)((String)idMap.getItem(0)), (Matcher)Matchers.is((Object)"abc"));
        Assert.assertThat((Object)((String)idMap.getItem(1)), (Matcher)Matchers.is((Object)"ab"));
    }

    @Test
    public void testFreeze() {
        ObjectIdMap<String> idMap = new ObjectIdMap<String>();
        idMap.add("abc");
        idMap.add("ab");
        idMap.freeze();
        try {
            idMap.add("abc");
            idMap.add("xyz");
            Assert.fail();
        }
        catch (ObjectIdMap.FrozenMapException frozenMapException) {
            // empty catch block
        }
        Assert.assertThat((Object)idMap.getId("ab"), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((String)idMap.getItem(0)), (Matcher)Matchers.is((Object)"abc"));
        Assert.assertThat((Object)((String)idMap.getItem(3)), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }
}

