/*
 * Decompiled with CFR 0.152.
 */
package soba.util.callgraph;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import soba.core.ClassInfo;
import soba.core.IDynamicBindingResolver;
import soba.core.JavaProgram;
import soba.core.MethodInfo;
import soba.core.method.CallSite;
import soba.util.IntPairList;
import soba.util.ObjectIdMap;
import soba.util.graph.DepthFirstSearch;
import soba.util.graph.DirectedGraph;
import soba.util.graph.IDepthFirstVisitor;

public class CallGraph {
    private ObjectIdMap<MethodInfo> methodToId = new ObjectIdMap();
    private DirectedGraph callGraph;
    private DirectedGraph reverseCallGraph;

    public CallGraph(JavaProgram program) {
        this(program, program.getClassHierarchy());
    }

    public CallGraph(JavaProgram program, IDynamicBindingResolver resolver) {
        for (ClassInfo c : program.getClasses()) {
            for (MethodInfo m : c.getMethods()) {
                this.methodToId.add(m);
            }
        }
        IntPairList edges = new IntPairList();
        for (ClassInfo c : program.getClasses()) {
            for (MethodInfo m : c.getMethods()) {
                for (CallSite cs : m.getCallSites()) {
                    MethodInfo[] callees;
                    MethodInfo[] methodInfoArray = callees = resolver.resolveCall(cs);
                    int n = callees.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MethodInfo callee = methodInfoArray[n2];
                        edges.add(this.methodToId.getId(m), this.methodToId.getId(callee));
                        ++n2;
                    }
                }
            }
        }
        this.callGraph = new DirectedGraph(this.methodToId.size(), edges);
        this.reverseCallGraph = this.callGraph.getReverseGraph();
    }

    public int size() {
        return this.methodToId.size();
    }

    public List<MethodInfo> getMethods() {
        ArrayList<MethodInfo> methodList = new ArrayList<MethodInfo>();
        int i = 0;
        while (i < this.methodToId.size()) {
            methodList.add(this.methodToId.getItem(i));
            ++i;
        }
        return methodList;
    }

    public List<MethodInfo> getCallees(MethodInfo caller) {
        int callerId = this.methodToId.getId(caller);
        ArrayList<MethodInfo> callees = new ArrayList<MethodInfo>();
        int[] nArray = this.callGraph.getEdges(callerId);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int calleeId = nArray[n2];
            callees.add(this.methodToId.getItem(calleeId));
            ++n2;
        }
        return callees;
    }

    public List<MethodInfo> getAllCallees(MethodInfo caller) {
        SimpleVisitor visitor = new SimpleVisitor();
        DepthFirstSearch.search(this.callGraph, this.methodToId.getId(caller), visitor);
        ArrayList<MethodInfo> callees = new ArrayList<MethodInfo>();
        int[] nArray = visitor.getVisitedIdsWithoutOwn();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int calleeId = nArray[n2];
            callees.add(this.methodToId.getItem(calleeId));
            ++n2;
        }
        return callees;
    }

    public List<MethodInfo> getCallers(MethodInfo callee) {
        int calleeId = this.methodToId.getId(callee);
        ArrayList<MethodInfo> callers = new ArrayList<MethodInfo>();
        int[] nArray = this.reverseCallGraph.getEdges(calleeId);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int callerId = nArray[n2];
            callers.add(this.methodToId.getItem(callerId));
            ++n2;
        }
        return callers;
    }

    public List<MethodInfo> getAllCallers(MethodInfo callee) {
        SimpleVisitor visitor = new SimpleVisitor();
        DepthFirstSearch.search(this.reverseCallGraph, this.methodToId.getId(callee), visitor);
        ArrayList<MethodInfo> callers = new ArrayList<MethodInfo>();
        int[] nArray = visitor.getVisitedIdsWithoutOwn();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int callerId = nArray[n2];
            callers.add(this.methodToId.getItem(callerId));
            ++n2;
        }
        return callers;
    }

    private class SimpleVisitor
    implements IDepthFirstVisitor {
        private TIntList visited = new TIntArrayList();

        private SimpleVisitor() {
        }

        private int[] getVisitedIdsWithoutOwn() {
            return this.visited.toArray(1, this.visited.size() - 1);
        }

        @Override
        public void onStart(int startVertexId) {
        }

        @Override
        public boolean onVisit(int vertexId) {
            if (this.visited.contains(vertexId)) {
                return false;
            }
            this.visited.add(vertexId);
            return true;
        }

        @Override
        public void onVisitAgain(int vertexId) {
        }

        @Override
        public void onLeave(int vertexId) {
        }

        @Override
        public void onFinished(boolean[] visited) {
        }
    }
}

