/*
 * Decompiled with CFR 0.152.
 */
package soba.util.debug;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.analysis.Frame;
import soba.core.ClassInfo;
import soba.core.JavaProgram;
import soba.core.MethodInfo;
import soba.core.method.DataDependence;
import soba.core.method.DataFlowEdge;
import soba.core.method.OpcodeString;
import soba.core.method.asm.FastSourceValue;
import soba.util.IntPairProc;
import soba.util.Timer;
import soba.util.files.Directory;
import soba.util.files.IClassList;
import soba.util.files.SingleFile;
import soba.util.files.ZipFile;
import soba.util.graph.DirectedGraph;

public class DumpClass {
    static Timer timer;
    static int classCount;
    static int methodCount;
    static int failedMethodCount;
    static long instructionCount;
    static long dataflowEdgeCount;
    static boolean enableOutput;
    static boolean dumpStackframe;
    static boolean dumpParamName;
    static boolean dumpTryBlock;

    static {
        classCount = 0;
        methodCount = 0;
        failedMethodCount = 0;
        instructionCount = 0L;
        dataflowEdgeCount = 0L;
        enableOutput = true;
        dumpStackframe = false;
        dumpParamName = false;
        dumpTryBlock = false;
    }

    public static void main(String[] args) {
        timer = new Timer();
        ArrayList<IClassList> files = new ArrayList<IClassList>();
        if (args.length == 0) {
            Directory bin = new Directory(new File("bin"));
            Directory lib = new Directory(new File("lib"));
            files.add(bin);
            files.add(lib);
        } else {
            String[] stringArray = args;
            int n = args.length;
            int lib = 0;
            while (lib < n) {
                String arg = stringArray[lib];
                if (arg.equals("--disable-output")) {
                    enableOutput = false;
                } else if (arg.equals("--output-frame")) {
                    dumpStackframe = true;
                } else if (arg.equals("--output-param")) {
                    dumpParamName = true;
                } else if (arg.equals("--output-try")) {
                    dumpTryBlock = true;
                } else {
                    File f = new File(arg);
                    if (f.isDirectory()) {
                        Directory dir = new Directory(f);
                        dir.enableRecursiveZipSearch();
                        files.add(dir);
                    } else if (ZipFile.isZipFile(f)) {
                        ZipFile zip = new ZipFile(f);
                        zip.enableRecursiveSearch();
                        files.add(zip);
                    } else {
                        SingleFile file = new SingleFile(f);
                        files.add(file);
                    }
                }
                ++lib;
            }
        }
        JavaProgram program = new JavaProgram(files.toArray(new IClassList[files.size()]));
        for (ClassInfo c : program.getClasses()) {
            DumpClass.processClass(c);
        }
        System.err.println("FINISHED: " + timer.getTotaltime() + " ms");
        System.err.println("#Classes: " + classCount);
        System.err.println("#Methods: " + methodCount);
        System.err.println("#Instructions: " + instructionCount);
        System.err.println("#Edges: " + dataflowEdgeCount);
        System.err.println("#Failed: " + failedMethodCount);
    }

    private static void processClass(ClassInfo c) {
        ++classCount;
        for (MethodInfo m : c.getMethods()) {
            MethodInfo methodInfo;
            if (enableOutput) {
                System.out.println(DumpClass.constructMethodNameString(c, m.getMethodNode()));
            }
            if (!(methodInfo = m).hasMethodBody()) continue;
            DataDependence info = methodInfo.getDataDependence();
            if (info != null) {
                int i;
                ++methodCount;
                instructionCount += (long)methodInfo.getInstructionCount();
                if (dumpParamName) {
                    i = 0;
                    while (i < methodInfo.getParamCount()) {
                        System.out.print("  Param ");
                        System.out.print(i + 1);
                        System.out.print(" ");
                        System.out.print(methodInfo.getParamType(i));
                        System.out.print(" ");
                        System.out.println(methodInfo.getParamName(i));
                        ++i;
                    }
                }
                i = 0;
                while (i < methodInfo.getInstructionCount()) {
                    if (enableOutput) {
                        System.out.println("  " + OpcodeString.getInstructionString(m.getMethodNode(), i));
                    }
                    if (dumpStackframe) {
                        DumpClass.dumpStackframe(info, i);
                    }
                    ++i;
                }
                if (dumpTryBlock && m.getMethodNode().tryCatchBlocks != null) {
                    System.out.println("  Try-catch Table:");
                    for (TryCatchBlockNode node : m.getMethodNode().tryCatchBlocks) {
                        System.out.println("    start=" + OpcodeString.getLabelString(m.getMethodNode(), node.start) + ", end=" + OpcodeString.getLabelString(m.getMethodNode(), node.end) + ", handler=" + OpcodeString.getLabelString(m.getMethodNode(), node.handler) + " (" + node.type + ")");
                    }
                    System.out.println("  Try-catch Table End");
                }
                List<DataFlowEdge> edges = info.getEdges();
                if (enableOutput) {
                    for (DataFlowEdge e : edges) {
                        System.out.print("    ");
                        System.out.print(e.toString());
                        System.out.print("  ");
                        String variableName = info.getVariableName(e);
                        if (variableName != null) {
                            System.out.print(String.valueOf(variableName) + ": " + info.getVariableDescriptor(e));
                        }
                        System.out.println();
                    }
                }
                dataflowEdgeCount += (long)edges.size();
                DirectedGraph cflow = methodInfo.getControlFlow();
                if (enableOutput) {
                    cflow.forEachEdge(new IntPairProc(){

                        @Override
                        public boolean execute(int elem1, int elem2) {
                            System.out.println("    [CFLOW] " + elem1 + " -> " + elem2);
                            return true;
                        }
                    });
                }
                DirectedGraph cdepends = methodInfo.getControlDependence();
                if (!enableOutput) continue;
                cdepends.forEachEdge(new IntPairProc(){

                    @Override
                    public boolean execute(int elem1, int elem2) {
                        System.out.println("    [Control] " + elem1 + " -> " + elem2);
                        return true;
                    }
                });
                continue;
            }
            ++failedMethodCount;
        }
    }

    private static void dumpStackframe(DataDependence info, int i) {
        Frame<?> f = info.getFrame(i);
        if (f == null) {
            if (enableOutput) {
                System.out.print("    ");
                System.out.print(i);
                System.out.println(" [STACK] null");
            }
        } else {
            int n;
            int size = f.getStackSize();
            int s = 0;
            while (s < size) {
                FastSourceValue source = (FastSourceValue)f.getStack(s);
                int[] nArray = source.getInstructions();
                n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int pos = nArray[n2];
                    if (enableOutput) {
                        System.out.print("    ");
                        System.out.print(i);
                        System.out.print(" [STACK] <");
                        System.out.print(s);
                        System.out.print("/");
                        System.out.print(size);
                        System.out.print("> ");
                        System.out.print(pos);
                        System.out.print(": ");
                        if (pos >= 0) {
                            System.out.println(info.getInstruction(pos).toString());
                        } else {
                            System.out.println("method param");
                        }
                    }
                    ++n2;
                }
                ++s;
            }
            int locals = f.getLocals();
            int l = 0;
            while (l < locals) {
                FastSourceValue source = (FastSourceValue)f.getLocal(l);
                int[] nArray = source.getInstructions();
                int n3 = nArray.length;
                n = 0;
                while (n < n3) {
                    int pos = nArray[n];
                    if (enableOutput) {
                        System.out.print("    ");
                        System.out.print(i);
                        System.out.print(" [LOCAL] <");
                        System.out.print(l);
                        System.out.print("/");
                        System.out.print(locals);
                        System.out.print("> ");
                        System.out.print(pos);
                        System.out.print(": ");
                        if (pos >= 0) {
                            System.out.println(info.getInstruction(pos).toString());
                        } else {
                            System.out.println("method param");
                        }
                    }
                    ++n;
                }
                ++l;
            }
            int consumeStack = info.getOperandCount(i);
            int maxStack = f.getStackSize();
            int s2 = 0;
            while (s2 < consumeStack) {
                FastSourceValue source = (FastSourceValue)f.getStack(maxStack - 1 - s2);
                int[] nArray = source.getInstructions();
                int n4 = nArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    int pos = nArray[n5];
                    if (enableOutput) {
                        System.out.print("    ");
                        System.out.print(i);
                        System.out.print(" [OPERAND");
                        System.out.print(s2);
                        System.out.print("] ");
                        System.out.print(pos);
                        System.out.print(": ");
                        if (pos >= 0) {
                            System.out.println(info.getInstruction(pos).toString());
                        } else {
                            System.out.println("method param");
                        }
                    }
                    ++n5;
                }
                ++s2;
            }
        }
        int[][] def = info.getDataDefinition(i);
        if (enableOutput) {
            int operandIndex = 0;
            while (operandIndex < def.length) {
                System.out.print("    Operand " + Integer.toString(operandIndex) + " Data Dependence: ");
                if (def[operandIndex] != null) {
                    if (def[operandIndex].length == 0) {
                        System.out.print("EMPTY");
                    } else {
                        int fromIndex = 0;
                        while (fromIndex < def[operandIndex].length) {
                            if (fromIndex > 0) {
                                System.out.print(", ");
                            }
                            System.out.print(def[operandIndex][fromIndex]);
                            ++fromIndex;
                        }
                    }
                } else {
                    System.out.print("null");
                }
                System.out.println();
                ++operandIndex;
            }
        }
    }

    private static String constructMethodNameString(ClassInfo c, MethodNode m) {
        StringBuilder buf = new StringBuilder();
        buf.append(c.getClassName());
        buf.append("#");
        buf.append(m.name);
        buf.append("#");
        buf.append(m.desc);
        buf.append("#");
        buf.append(m.signature);
        if ((m.access & 0x1000) != 0) {
            buf.append(" [Synthetic]");
        }
        return buf.toString();
    }

    private static void dumpVariables(MethodNode m) {
        List variables = m.localVariables;
        if (variables != null) {
            System.out.println("---VARIABLES BEGIN---");
            for (LocalVariableNode v : variables) {
                System.out.println("   " + v.name + ": " + v.desc + " ");
            }
            System.out.println("---VARIABLES END---");
        }
    }
}

