/*
 * Decompiled with CFR 0.152.
 */
package soba.util.files;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import soba.util.files.ClasspathUtil;
import soba.util.files.IClassList;

public class ClasspathUtilTest {
    @Test
    public void testEnumerateSystemClasspath() {
        List<String> systemList = ClasspathUtil.enumerateSystemClasspath();
        Assert.assertThat(systemList, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testMerge() {
        IClassList[] e1 = ClasspathUtil.getClassList(new String[]{"."});
        IClassList[] e2 = ClasspathUtil.getClassList(new String[]{"..", "."});
        IClassList[] e3 = ClasspathUtil.merge(e1, e2);
        Assert.assertThat((Object)(e1[0] == e3[0] ? 1 : 0), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)(e2[0] == e3[1] ? 1 : 0), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)(e2[1] == e3[2] ? 1 : 0), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGetClassList() {
        String[] fileArray = new String[]{"bin/soba/testdata"};
        IClassList[] results1 = ClasspathUtil.getClassList(fileArray);
        Assert.assertThat((Object)results1, (Matcher)Matchers.is((Matcher)Matchers.arrayWithSize((int)1)));
        IClassList[] results2 = ClasspathUtil.getClassList(fileArray, "");
        Assert.assertThat((Object)results2, (Matcher)Matchers.is((Matcher)Matchers.arrayWithSize((int)1)));
        ArrayList<String> fileList = new ArrayList<String>();
        fileList.add("bin/soba/testdata");
        IClassList[] results3 = ClasspathUtil.getClassList(fileList);
        Assert.assertThat((Object)results3, (Matcher)Matchers.is((Matcher)Matchers.arrayWithSize((int)1)));
        IClassList[] results4 = ClasspathUtil.getClassList(fileList, null);
        Assert.assertThat((Object)results4, (Matcher)Matchers.is((Matcher)Matchers.arrayWithSize((int)1)));
        String[] zipFile = new String[]{"lib/asm-debug-all-5.0.3.jar"};
        IClassList[] results5 = ClasspathUtil.getClassList(zipFile);
        Assert.assertThat((Object)results5, (Matcher)Matchers.is((Matcher)Matchers.arrayWithSize((int)1)));
        String[] classFile = new String[]{"bin/soba/testdata/DefUseTestData.class"};
        IClassList[] results6 = ClasspathUtil.getClassList(classFile);
        Assert.assertThat((Object)results6, (Matcher)Matchers.is((Matcher)Matchers.arrayWithSize((int)1)));
        String[] appFiles = new String[]{"bin/soba/testdata/DefUseTestData.class"};
        String[] libFiles = new String[]{"lib/asm-debug-all-5.0.3.jar"};
        IClassList[] results7 = ClasspathUtil.getClassList(appFiles, libFiles);
        Assert.assertThat((Object)results7, (Matcher)Matchers.is((Matcher)Matchers.arrayWithSize((int)2)));
        Assert.assertThat((Object)results7[1].getLabel(), (Matcher)Matchers.is((Object)"$library$"));
    }
}

