/*
 * Decompiled with CFR 0.152.
 */
package soba.util.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import soba.util.files.IClassList;
import soba.util.files.IClassListCallback;

public class SingleFile
implements IClassList {
    private File file;
    private String label;

    public SingleFile(File f) {
        assert (f.isFile()) : String.valueOf(f.getAbsolutePath()) + " is not a file.";
        this.file = f;
    }

    public void setLabel(String l) {
        this.label = l;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void process(IClassListCallback c) {
        String filename = this.file.getAbsolutePath();
        if (c.isTarget(filename)) {
            try {
                FileInputStream binaryStream = new FileInputStream(this.file);
                c.process(filename, binaryStream);
                binaryStream.close();
            }
            catch (IOException e) {
                c.reportError(filename, e);
            }
        }
    }
}

