/*
 * Decompiled with CFR 0.152.
 */
package soba.util.graph;

import java.util.Stack;
import soba.util.graph.IDepthFirstVisitor;
import soba.util.graph.IDirectedGraph;

public class DepthFirstSearch {
    public static void search(IDirectedGraph graph, int startVertexId, IDepthFirstVisitor visit) {
        Stack<DfsProgress> stack = new Stack<DfsProgress>();
        boolean[] visited = new boolean[graph.getVertexCount()];
        visit.onStart(startVertexId);
        DfsProgress progress = new DfsProgress(graph, startVertexId);
        stack.push(progress);
        while (!stack.isEmpty()) {
            boolean continueVisit;
            DfsProgress node = (DfsProgress)stack.peek();
            boolean isFirstVisit = !visited[node.getVertex()];
            visited[node.getVertex()] = true;
            if (isFirstVisit && !(continueVisit = visit.onVisit(node.getVertex()))) {
                stack.pop();
                visit.onLeave(node.getVertex());
                continue;
            }
            int nextNode = -1;
            while (node.hasNext()) {
                int nextNodeCandidate = node.next();
                if (!visited[nextNodeCandidate]) {
                    nextNode = nextNodeCandidate;
                    break;
                }
                visit.onVisitAgain(nextNodeCandidate);
            }
            if (nextNode != -1) {
                stack.push(new DfsProgress(graph, nextNode));
                continue;
            }
            stack.pop();
            visit.onLeave(node.getVertex());
        }
        visit.onFinished(visited);
    }

    private static class DfsProgress {
        private IDirectedGraph graph;
        private int vertex;
        private int edgeIndex;

        public DfsProgress(IDirectedGraph graph, int vertexId) {
            this.graph = graph;
            this.vertex = vertexId;
            this.edgeIndex = 0;
        }

        public int getVertex() {
            return this.vertex;
        }

        public boolean hasNext() {
            int[] edgeList = this.graph.getEdges(this.vertex);
            return edgeList != null && this.edgeIndex < edgeList.length;
        }

        public int next() {
            if (this.graph.getEdges(this.vertex) != null) {
                int next = this.graph.getEdges(this.vertex)[this.edgeIndex];
                ++this.edgeIndex;
                return next;
            }
            return -1;
        }
    }
}

