/*
 * Decompiled with CFR 0.152.
 */
package soba.util.graph;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import soba.util.IntPairProc;
import soba.util.UtilForAssertThat;
import soba.util.graph.DirectedAcyclicGraph;
import soba.util.graph.DirectedGraph;
import soba.util.graph.GraphTestBase;

public class DirectedAcyclicGraphTest {
    DirectedGraph graph;
    DirectedAcyclicGraph dag;

    @Before
    public void buildGraph() throws Exception {
        this.graph = GraphTestBase.buildGraph();
        this.dag = new DirectedAcyclicGraph(this.graph);
    }

    @Test
    public void testAcyclicGraphNodes() {
        Assert.assertThat((Object)this.dag.getVertexCount(), (Matcher)Matchers.is((Object)this.graph.getVertexCount()));
        Assert.assertThat((Object)this.dag.getVertexCount(), (Matcher)Matchers.is((Object)this.graph.getVertexCount()));
        Assert.assertThat((Object)this.dag.isRepresentativeNode(0), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.dag.isRepresentativeNode(1), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.dag.isRepresentativeNode(2), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.dag.isRepresentativeNode(3), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.dag.isRepresentativeNode(4), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.dag.isRepresentativeNode(5), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.dag.isRepresentativeNode(6), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.dag.isRepresentativeNode(7), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.dag.isRepresentativeNode(8), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.dag.isRepresentativeNode(9), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.dag.isRepresentativeNode(10), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.dag.isRepresentativeNode(11), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.dag.isRepresentativeNode(12), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.dag.isRepresentativeNode(13), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAcyclicGraphEdges() {
        this.dag.forEachEdge(new IntPairProc(){
            int index = 0;
            int[][] expected;
            {
                int[][] nArrayArray = new int[8][];
                int[] nArray = new int[2];
                nArray[1] = 3;
                nArrayArray[0] = nArray;
                nArrayArray[1] = new int[]{3, 4};
                nArrayArray[2] = new int[]{3, 5};
                nArrayArray[3] = new int[]{5, 9};
                nArrayArray[4] = new int[]{5, 10};
                nArrayArray[5] = new int[]{9, 11};
                nArrayArray[6] = new int[]{10, 11};
                nArrayArray[7] = new int[]{11, 12};
                this.expected = nArrayArray;
            }

            @Override
            public boolean execute(int elem1, int elem2) {
                Assert.assertThat((Object)elem1, (Matcher)Matchers.is((Object)this.expected[this.index][0]));
                Assert.assertThat((Object)elem2, (Matcher)Matchers.is((Object)this.expected[this.index][1]));
                ++this.index;
                return true;
            }
        });
        Assert.assertThat((Object)UtilForAssertThat.asIntegerArray(this.dag.getEdges(13)), (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)UtilForAssertThat.asIntegerArray(this.dag.getEdges(3)), (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{4, 5})));
    }
}

