/*
 * Decompiled with CFR 0.152.
 */
package soba.util.graph;

import soba.util.IntPairList;
import soba.util.IntPairProc;
import soba.util.graph.DirectedAcyclicGraph;
import soba.util.graph.DirectedGraph;
import soba.util.graph.IDirectedGraph;

public class SingleRootDirectedGraph
implements IDirectedGraph {
    private IDirectedGraph base;
    private int[] edgesFromRoot;

    public SingleRootDirectedGraph(IDirectedGraph base) {
        this.base = base;
        DirectedAcyclicGraph dag = new DirectedAcyclicGraph(base);
        final boolean[] hasIncomingEdge = new boolean[base.getVertexCount()];
        dag.forEachEdge(new IntPairProc(){

            @Override
            public boolean execute(int from, int to) {
                hasIncomingEdge[to] = true;
                return true;
            }
        });
        int count = 0;
        int i = 0;
        while (i < hasIncomingEdge.length) {
            if (!hasIncomingEdge[i] && dag.isRepresentativeNode(i)) {
                ++count;
            }
            ++i;
        }
        this.edgesFromRoot = new int[count];
        int edgeIndex = 0;
        int i2 = 0;
        while (i2 < base.getVertexCount()) {
            if (!hasIncomingEdge[i2] && dag.isRepresentativeNode(i2)) {
                this.edgesFromRoot[edgeIndex] = i2;
                ++edgeIndex;
            }
            ++i2;
        }
    }

    public int getRootId() {
        return this.base.getVertexCount();
    }

    @Override
    public int getVertexCount() {
        return this.base.getVertexCount() + 1;
    }

    @Override
    public int[] getEdges(int memberId) {
        if (memberId < this.base.getVertexCount()) {
            return this.base.getEdges(memberId);
        }
        return this.edgesFromRoot;
    }

    @Override
    public void forEachEdge(IntPairProc proc) {
        int n;
        int from = 0;
        while (from < this.base.getVertexCount()) {
            int[] nArray = this.base.getEdges(from);
            int n2 = nArray.length;
            n = 0;
            while (n < n2) {
                int to = nArray[n];
                if (!proc.execute(from, to)) {
                    return;
                }
                ++n;
            }
            ++from;
        }
        int[] nArray = this.edgesFromRoot;
        n = this.edgesFromRoot.length;
        int n3 = 0;
        while (n3 < n) {
            int to = nArray[n3];
            if (!proc.execute(this.getRootId(), to)) {
                return;
            }
            ++n3;
        }
    }

    public DirectedGraph getReverseGraph() {
        final IntPairList reverseEdges = new IntPairList();
        this.base.forEachEdge(new IntPairProc(){

            @Override
            public boolean execute(int elem1, int elem2) {
                reverseEdges.add(elem2, elem1);
                return true;
            }
        });
        int[] nArray = this.getEdges(this.getRootId());
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            reverseEdges.add(id, this.getRootId());
            ++n2;
        }
        return new DirectedGraph(this.getVertexCount(), reverseEdges);
    }
}

