<?php
class SearchFormlet {
  function show() {
    SearchFormlet::showInputForm("");
  }

  function showInputForm($str) {
    $escaped = htmlspecialchars($str);
    ?>
    <form action="index.php" method="post">
    <input type="hidden" name="action" value="search">
    <input type="text" size="50" name="key" value="<?php echo $escaped ?>">
    <input type="submit" value="Search">
    <input type="reset" value="Reset">
    </form>
    <?php
  }

  function action($params) {
    $key = $params["key"];
    SearchFormlet::showInputForm($key);
    $pages = WikiPageStorage::search($key);
    $comments = WikiCommentStorage::search($key);
    $hits = count($pages) + count($comments);

    $escaped = htmlspecialchars($key);
    ?>
    <?php if ($hits > 0): ?>
      <h2><?php echo $escaped ?>ɤθ</h2>
      <h3>ʸ</h3>
      <ul>
        <?php foreach($pages as $page): ?>
          <li><?php echo Formatter::linkToPage($page) ?></li>
        <?php endforeach; ?>
      </ul>
      <h3></h3>
      <ul>
        <?php foreach($comments as $comment): ?>
          <li><?php echo Formatter::linkToAllComment($comment) ?></li>
        <?php endforeach; ?>
      </ul>
   	<? else: ?>
      <h3>Ĥޤ</h3>
	<? endif; ?>
    <p><a href="index.php">Top</a></p>
    <?php
  }
}
?>
