<?php
/*
  Copyright (C) 2005-2006 SHIMADA Keiki
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

error_reporting(E_ALL);
require_once 'resources/config.php';
require_once 'formlet/core.frm.php';
require_once 'formlet/wiki.frm.php';
require_once 'formlet/comment.frm.php';
require_once 'formlet/queue.frm.php';
require_once 'formlet/watch.frm.php';
require_once 'formlet/userconf.frm.php';
require_once 'formlet/calendar.frm.php';
require_once 'formlet/memo.frm.php';
require_once 'formlet/search.frm.php';
require_once 'lib/session.php';
require_once 'lib/storage.php';
require_once 'lib/account.php';
require_once 'lib/formatter.php';
require_once 'lib/rss.php';

$db = new HashDB("metadata/accounts.hash");
$manager = new AccountManager($db);

$pdb = new HashDB("metadata/property.hash");
$pdbReadOnly = new ReadOnlyHashDB("metadata/property.hash");

WebSession::start();
set_request();
check_no_users();

if ($method == 'GET' && isset($request['mod'])) {
  switch ($request['mod']) {
  case 'Top':
    apply_template('Top', 'Site top');
    break;
  case 'Login':
    apply_template('Login', 'Login page');
    break;
  case 'Account':
    apply_template('Account', 'Account registration');
    break;
  case 'WikiEdit':
    check_logined();
    check_pagename($request["name"]);
    apply_template('WikiEdit', 'Edit: '.$request["name"]);
    break;
  case 'WikiView':
    if (!isset($request["name"])) show_top();
    check_pagename($request["name"]);
    apply_template('WikiView', $request["name"]);
    break;
  case 'NewPage':
    check_logined();
    apply_template('NewPage', "Create New Page");
    break;
  case 'WikiHistory':
    check_pagename($request["name"]);
    apply_template('WikiHistory', $request["name"]);
    break;
  case 'WikiVersion':
    check_pagename($request["name"]);
    apply_template('WikiVersion', "old version of ".$request["name"]);
    break;
  case 'QueueLogEdit':
    check_logined();
    apply_template('QueueLogEdit', "QueueList log edit");
    break;
  case 'AllComment':
    apply_template('AllComment', "All Comment of ".$request["name"]);
    break;
  case 'WatchListEdit':
    check_logined();
    apply_template('WatchListEdit', "Watch List Edit");
    break;
  case 'WatchList':
    check_logined();
    apply_template('WatchList', "Watch List");
    break;
  case 'AllPages':
    apply_template('AllPages', "All pages");
    break;
  case 'UserConf':
    check_logined();
    apply_template('UserConf', "User configuration");
    break;
  case 'FormletLauncher':
    check_logined();
    apply_template('FormletLauncher', "Formlet Launcher: ".$request['formlet']);
    break;
  case 'Calendar':
    check_logined();
    apply_template('Calendar', "Calendar");
    break;
  case 'ChangePassword':
    check_logined();
    apply_template('ChangePassword', "Calendar");
    break;
  case 'CommentEdit':
    check_logined();
    apply_template('CommentEdit', "Edit Last Comment");
    break;
  case 'Search':
    apply_template('Search', "Search");
    break;
  default:
    print "error";
    break;
  }
}
elseif (isset($request['action'])) {
  switch ($request['action']) {
  case 'search':
    SearchFormlet::action($request);
    break;
  case 'login':
	method_must_be_post();
    LoginFormlet::action($request);
    break;
  case 'logout':
    check_logined();
    WebSession::logout();
    redirect_to("index.php", "Ȥޤ");
    break;
  case 'account':
	method_must_be_post();
    CreateAccountFormlet::action($request);
    break;
  case 'wikiedit':
    check_logined();
    check_pagename($request["name"]);
    WikiEditFormlet::action($request);
    break;
  case 'comment':
    method_must_be_post();
    check_pagename($request["name"]);
    CommentFormlet::action($request);
    break;
  case 'queue':
    check_logined();
    QueueListFormlet::action($request);
    break;
  case 'queuelogedit':
    method_must_be_post();
    check_logined();
    QueueLogEditFormlet::action($request);
    break;
  case 'watchlistedit':
    method_must_be_post();
    check_logined();
    WatchListEditFormlet::action($request);
    break;
  case 'formletedit':
    method_must_be_post();
    check_logined();
    FormletEditFormlet::action($request);
    break;
  case 'addtowatchlist':
    method_must_be_post();
    check_logined();
    WatchListAddFormlet::action($request);
    break;
  case 'themechoose':
    method_must_be_post();
    check_logined();
    ThemechooseFormlet::action($request);
    break;
  case 'changePassword':
    method_must_be_post();
    check_logined();
    ChangePasswordFormlet::action($request);
    break;
  case 'lastCommentEdit':
    method_must_be_post();
    check_logined();
    method_must_be_post();
    CommentEditFormlet::action($request);
    break;
  case 'memosave':
    method_must_be_post();
    check_logined();
    MemoFormlet::action($request);
    break;
  case 'search':
    SearchFormlet::action($request);
    break;
  case 'createadmin':
    method_must_be_post();
    if (count($manager->accounts()) > 0) die("CA error 1.");
    break;
  default:
    redirect_to("index.php", "action error");
    break;
  }
}
else {
  show_top();
}
// end of main
exit;

function apply_template($mod, $title) {
  global $session, $manager, $request;
  $module = 'module/'.$mod.'.mod.php';
  include 'resources/skin.html.php';
}


function redirect_to($url, $mes, $int = 2) {
  ?>
 <html>
    <meta http-equiv="Content-Type" content="text/html; charset=euc-jp">
    <meta http-equiv="Refresh" content="<?php echo $int ?>;URL=<?php echo $url ?>">
    <p><?php echo $mes ?><br><a href="<?php echo $url ?>">Back</a></p>
    <?php
    }

function check_naming_rule($str) {
  return preg_match(NAME_PAT, $str) == 1;
}

function check_pagename($name) {
  check_naming_rule($name) or die("page name error");
}

function check_logined() {
  WebSession::isLogined() or die("you are not logined");
}

function set_request() {
  global $request, $method;

  $method = $_SERVER['REQUEST_METHOD'];
  if ($method == 'GET') {
    $request = $_GET;
  }
  elseif ($method == 'POST') {
    $request = $_POST;
  }
  if (get_magic_quotes_gpc()) {
    $request = array_stripslashes_recursive($request);
  }
  if (!isset($request['mod']) and !isset($request['action'])) {
    show_top();
  }
}

function show_top() {
  check_no_users();
  apply_template('Top', 'Site top');
  exit;
}

function method_must_be_post() {
  global $method;

  if ($method != "POST") {
    die("method must be post.");
  }
}

function check_no_users() {
  global $manager, $request, $method;

  // proccess when attenpt to create admin user.
  if ($method == 'POST' && isset($request['action']) && $request['action'] == 'createadmin') {
    CreateAdminFormlet::action($request);
    exit;
  }
  // there is no user. admin account is required.
  elseif ((count($manager->accounts()) == 0)) {
    apply_template('CreateAdmin', 'Create Admin User');
    exit;
  }
  // normal case.
  return;
}

function array_stripslashes_recursive($var) {
  if (is_array($var))
    return array_map('array_stripslashes_recursive', $var);
  else
    return stripslashes($var);
}

?>
