package org.dyndns.nuda.mapper;

import java.lang.reflect.Proxy;
import java.sql.Connection;

/**
 * JavaインタフェースクラスとSQLXMLを連動させるためのハンドラを生成するファクトリです
 * (iBatis近似？？？)
 * 
 * @author nkoseki
 * 
 */
public class JDBCQueryHandler {
	private JDBCQueryHandler() {
		// インスタンス化させない
	}
	
	/**
	 * コネクションオブジェクト・ハンドラクラスオブジェクトを指定してJDBCHandlerを生成します
	 * 
	 * @param <H>
	 *            ハンドラクラス型
	 * @param con
	 *            コネクションオブジェクト
	 * @param handlerClass
	 *            ハンドラクラスオブジェクト
	 * @return JDBCHandler
	 * @throws Exception
	 *             例外が発生した場合にスローされます
	 */
	public static <H> H getHandler(final Connection con,
			final Class<H> handlerClass) throws Exception {
		H result = null;
		
		ClassLoader currentClassLoader = handlerClass.getClassLoader();
		ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
		
		Thread.currentThread().setContextClassLoader(currentClassLoader);
		
		JDBCXMLInvocationHandler handler = new JDBCXMLInvocationHandler(con,
				handlerClass, currentClassLoader);
		
		Object intf = Proxy.newProxyInstance(Thread.currentThread()
				.getContextClassLoader(), new Class<?>[] { handlerClass },
				handler);
		
		result = handlerClass.cast(intf);
		
		Thread.currentThread().setContextClassLoader(oldLoader);
		
		return result;
	}
	
	/**
	 * コネクションオブジェクト・ハンドラクラスオブジェクト・SQLXMLを参照可能なクラスローダを指定してJDBCHandlerを生成します
	 * 
	 * @param <H>
	 *            ハンドラクラス型
	 * @param con
	 *            コネクションオブジェクト
	 * @param handlerClass
	 *            ハンドラクラスオブジェクト
	 * @param loader
	 *            SQLXMLを参照可能なクラスローダ
	 * @return JDBCHandler
	 * @throws Exception
	 *             例外が発生した場合にスローされます
	 */
	public static <H> H getHandler(final Connection con,
			final Class<H> handlerClass, final ClassLoader loader)
			throws Exception {
		
		ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
		
		Thread.currentThread().setContextClassLoader(loader);
		
		H result = null;
		
		JDBCXMLInvocationHandler handler = new JDBCXMLInvocationHandler(con,
				handlerClass, loader);
		
		Object intf = Proxy.newProxyInstance(Thread.currentThread()
				.getContextClassLoader(), new Class<?>[] { handlerClass },
				handler);
		
		result = handlerClass.cast(intf);
		
		Thread.currentThread().setContextClassLoader(oldLoader);
		
		return result;
	}
}
