/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper.driver;

import java.sql.Connection;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.dyndns.nuda.mapper.connection.SQLInterfaceConnection;
import org.dyndns.nuda.mapper.driver.SorMapDriver;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SorMapDriverTest
extends TestCase {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testConnect01_valid() {
        SorMapDriver d = new SorMapDriver();
        String url = "jdbc:sormap://localhost:3306/world?subProtocol=mysql";
        Properties prop = new Properties();
        prop.put("user", "root");
        prop.put("password", "bpg26rtdyy");
        try {
            Connection con = d.connect(url, prop);
            if (con == null) {
                Assert.fail((String)"connection=null");
            }
            if (con instanceof SQLInterfaceConnection) {
                Assert.assertTrue((boolean)true);
            } else {
                Assert.fail((String)"connection=not equal SQLInterfaceConnection");
            }
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testConnect02_valid() {
        SorMapDriver d = new SorMapDriver();
        String url = "jdbc:sormap://localhost:3306/world";
        Properties prop = new Properties();
        prop.put("user", "root");
        prop.put("password", "bpg26rtdyy");
        prop.put("subProtocol", "mysql");
        try {
            Connection con = d.connect(url, prop);
            if (con == null) {
                Assert.fail((String)"connection=null");
            }
            if (con instanceof SQLInterfaceConnection) {
                Assert.assertTrue((boolean)true);
            } else {
                Assert.fail((String)"connection=not equal SQLInterfaceConnection");
            }
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testConnect03_invalid() {
        SorMapDriver d = new SorMapDriver();
        String url = "jdbc:sormap://localhost:3306/world";
        Properties prop = new Properties();
        prop.put("user", "invaliduser");
        prop.put("password", "bpg26rtdyy");
        prop.put("subProtocol", "mysql");
        try {
            d.connect(url, prop);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertTrue((String)"", (boolean)true);
        }
    }

    @Test
    public void testConnect04_invalid() {
        SorMapDriver d = new SorMapDriver();
        String url = "jdbc:sormap://localhost:3306/world";
        Properties prop = new Properties();
        prop.put("user", "root");
        prop.put("password", "invalidpass");
        prop.put("subProtocol", "mysql");
        try {
            d.connect(url, prop);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertTrue((String)"", (boolean)true);
        }
    }

    @Test
    public void testConnect05_invalid() {
        SorMapDriver d = new SorMapDriver();
        String url = "jdbc:sormap://localhost:3306/world";
        Properties prop = new Properties();
        prop.put("user", "root");
        prop.put("password", "invalidpass");
        try {
            d.connect(url, prop);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertTrue((String)"", (boolean)true);
        }
    }

    @Test
    public void testConnect06_invalid() {
        SorMapDriver d = new SorMapDriver();
        String url = "jdbc:sormap://localhost:3306/world";
        Properties prop = new Properties();
        prop.put("user", "root");
        prop.put("password", "invalidpass");
        prop.put("subProtocol", "test");
        try {
            d.connect(url, prop);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertTrue((String)"", (boolean)true);
        }
    }

    @Test
    public void testAcceptsURL01_valid() {
        SorMapDriver d = new SorMapDriver();
        String url = "jdbc:sormap://localhost:3306/testdb?subProtocol=mysql";
        try {
            Assert.assertTrue((String)"acceptsURL\u4e0d\u6b63", (boolean)d.acceptsURL(url));
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAcceptsURL02_invalid() {
        SorMapDriver d = new SorMapDriver();
        String url = "jdbc:sormap2://localhost:3306/testdb?subProtocol=mysql";
        try {
            Assert.assertTrue((String)"acceptsURL\u4e0d\u6b63:subProtocol\u4e0d\u6b63", (!d.acceptsURL(url) ? 1 : 0) != 0);
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetPropertyInfo01_valid() {
        SorMapDriver d = new SorMapDriver();
        String url = "jdbc:sormap://localhost:3306/world";
        Properties prop = new Properties();
        prop.put("user", "root");
        prop.put("password", "bpg26rtdyy");
        prop.put("subProtocol", "mysql");
        try {
            DriverPropertyInfo[] infos;
            DriverPropertyInfo[] driverPropertyInfoArray = infos = d.getPropertyInfo(url, prop);
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                DriverPropertyInfo info = driverPropertyInfoArray[n2];
                if ("user".equals(info.name) && info.required) {
                    if (info.value.equals("root")) {
                        Assert.assertTrue((boolean)true);
                    } else {
                        Assert.fail((String)"DriverPropertyInfo\u4e0d\u6b63");
                    }
                } else if ("password".equals(info.name) && info.required) {
                    if (info.value.equals("bpg26rtdyy")) {
                        Assert.assertTrue((boolean)true);
                    } else {
                        Assert.fail((String)"DriverPropertyInfo\u4e0d\u6b63");
                    }
                } else if ("subProtocol".equals(info.name) && !info.required) {
                    if (info.value.equals("mysql")) {
                        Assert.assertTrue((boolean)true);
                    } else {
                        Assert.fail((String)"DriverPropertyInfo\u4e0d\u6b63");
                    }
                } else {
                    Assert.fail((String)"DriverPropertyInfo\u4e0d\u6b63");
                }
                ++n2;
            }
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetPropertyInfo02_valid() {
        SorMapDriver d = new SorMapDriver();
        String url = "jdbc:sormap://localhost:3306/world?subProtocol=mysql";
        Properties prop = new Properties();
        prop.put("user", "root");
        prop.put("password", "bpg26rtdyy");
        try {
            DriverPropertyInfo[] infos;
            DriverPropertyInfo[] driverPropertyInfoArray = infos = d.getPropertyInfo(url, prop);
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                DriverPropertyInfo info = driverPropertyInfoArray[n2];
                if ("user".equals(info.name) && info.required) {
                    if (info.value.equals("root")) {
                        Assert.assertTrue((boolean)true);
                    } else {
                        Assert.fail((String)"DriverPropertyInfo\u4e0d\u6b63");
                    }
                } else if ("password".equals(info.name) && info.required) {
                    if (info.value.equals("bpg26rtdyy")) {
                        Assert.assertTrue((boolean)true);
                    } else {
                        Assert.fail((String)"DriverPropertyInfo\u4e0d\u6b63");
                    }
                } else if ("subProtocol".equals(info.name) && !info.required) {
                    if (info.value.equals("mysql")) {
                        Assert.assertTrue((boolean)true);
                    } else {
                        Assert.fail((String)"DriverPropertyInfo\u4e0d\u6b63");
                    }
                } else {
                    Assert.fail((String)"DriverPropertyInfo\u4e0d\u6b63");
                }
                ++n2;
            }
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetPropertyInfo03_invalid() {
        SorMapDriver d = new SorMapDriver();
        String url = "jdbc:sormap://localhost:3306/world";
        Properties prop = new Properties();
        prop.put("user", "root");
        prop.put("password", "bpg26rtdyy");
        try {
            DriverPropertyInfo[] infos;
            DriverPropertyInfo[] driverPropertyInfoArray = infos = d.getPropertyInfo(url, prop);
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                DriverPropertyInfo info = driverPropertyInfoArray[n2];
                if ("user".equals(info.name) && info.required) {
                    if (info.value.equals("root")) {
                        Assert.assertTrue((boolean)true);
                    } else {
                        Assert.fail((String)"DriverPropertyInfo\u4e0d\u6b63");
                    }
                } else if ("password".equals(info.name) && info.required) {
                    if (info.value.equals("bpg26rtdyy")) {
                        Assert.assertTrue((boolean)true);
                    } else {
                        Assert.fail((String)"DriverPropertyInfo\u4e0d\u6b63");
                    }
                } else if (!"subProtocol".equals(info.name) || info.required) {
                    Assert.fail((String)"DriverPropertyInfo\u4e0d\u6b63");
                }
                ++n2;
            }
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testGetMajorVersion() {
        SorMapDriver d = new SorMapDriver();
        Assert.assertEquals((int)0, (int)d.getMajorVersion());
    }

    @Test
    public void testGetMinorVersion() {
        SorMapDriver d = new SorMapDriver();
        Assert.assertEquals((int)0, (int)d.getMinorVersion());
    }

    @Test
    public void testJdbcCompliant() {
        SorMapDriver d = new SorMapDriver();
        Assert.assertTrue((!d.jdbcCompliant() ? 1 : 0) != 0);
    }
}

