/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper.driver;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.dyndns.nuda.mapper.connection.SQLInterfaceConnection;
import org.dyndns.nuda.mapper.driver.helper.ConStrRegexBean;
import org.dyndns.nuda.mapper.driver.helper.RealSubProtocolRegexBean;
import org.dyndns.nuda.tools.regex.RegexProcessor;
import org.dyndns.nuda.tools.util.StringUtil;

public class SorMapDriver
implements Driver {
    static {
        try {
            DriverManager.registerDriver(new SorMapDriver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (this.acceptsURL(url)) {
            RegexProcessor p = new RegexProcessor();
            ConStrRegexBean bean = (ConStrRegexBean)p.processBySingle(url, ConStrRegexBean.class);
            RealSubProtocolRegexBean subProtocolBean = (RealSubProtocolRegexBean)p.processBySingle(url, RealSubProtocolRegexBean.class);
            String realURL = null;
            if (subProtocolBean.realSubProtocol != null) {
                realURL = StringUtil.format((String)"jdbc:{}://{}", (Object[])new Object[]{subProtocolBean.realSubProtocol, bean.dir});
            } else if (info != null && info.containsKey("subProtocol")) {
                realURL = StringUtil.format((String)"jdbc:{}://{}", (Object[])new Object[]{info.get("subProtocol"), bean.dir});
            }
            if (realURL != null) {
                Connection con0 = DriverManager.getConnection(realURL, info);
                con0 = new SQLInterfaceConnection(con0);
                return con0;
            }
            throw new SQLException("realURL IS NULL");
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        RegexProcessor p = new RegexProcessor();
        ConStrRegexBean bean = (ConStrRegexBean)p.processBySingle(url, ConStrRegexBean.class);
        return "sormap".equals(bean.subProtocol);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        RegexProcessor p = new RegexProcessor();
        RealSubProtocolRegexBean subProtocolBean = (RealSubProtocolRegexBean)p.processBySingle(url, RealSubProtocolRegexBean.class);
        if (subProtocolBean.realSubProtocol != null) {
            info.put("subProtocol", subProtocolBean.realSubProtocol);
        } else if (info != null && !info.containsKey("subProtocol")) {
            throw new SQLException("subProtocol is NULL");
        }
        ArrayList<DriverPropertyInfo> infoList = new ArrayList<DriverPropertyInfo>();
        DriverPropertyInfo dp01 = new DriverPropertyInfo("user", info.getProperty("user"));
        DriverPropertyInfo dp02 = new DriverPropertyInfo("password", info.getProperty("password"));
        DriverPropertyInfo dp03 = new DriverPropertyInfo("subProtocol", info.getProperty("subProtocol"));
        dp01.description = "username";
        dp01.required = true;
        dp02.description = "password";
        dp02.required = true;
        dp03.description = "sub_protocol";
        dp03.required = false;
        infoList.add(dp01);
        infoList.add(dp02);
        infoList.add(dp03);
        return infoList.toArray(new DriverPropertyInfo[infoList.size()]);
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }
}

