/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper.helper;

import java.lang.reflect.Method;
import java.util.Arrays;

public class CommandSigniture {
    private String methodName = "";
    private Class<?> returnType;
    private Class<?>[] paramTypes;
    private Method origin;

    public CommandSigniture(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("first-parameter[method] is cannot be null");
        }
        this.methodName = method.getName();
        this.returnType = method.getReturnType();
        this.paramTypes = method.getParameterTypes();
        this.origin = method;
    }

    public String getCommandName() {
        return this.methodName;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Class<?>[] getParamTypes() {
        return Arrays.copyOf(this.paramTypes, this.paramTypes.length);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + Arrays.hashCode(this.paramTypes);
        result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommandSigniture other = (CommandSigniture)obj;
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        if (!Arrays.equals(this.paramTypes, other.paramTypes)) {
            return false;
        }
        if (this.paramTypes.length != other.paramTypes.length) {
            return false;
        }
        int idx = 0;
        while (idx < this.paramTypes.length) {
            Class<?> a = this.paramTypes[idx];
            Class<?> b = other.paramTypes[idx];
            if (!a.getCanonicalName().equals(b.getCanonicalName())) {
                return false;
            }
            ++idx;
        }
        return !(this.returnType == null ? other.returnType != null : !this.returnType.getCanonicalName().equals(other.returnType.getCanonicalName()));
    }

    public String toString() {
        String param = "";
        int count = 0;
        Class<?>[] classArray = this.paramTypes;
        int n = this.paramTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cls = classArray[n2];
            param = count == this.paramTypes.length - 1 ? String.valueOf(param) + cls.getCanonicalName() : String.valueOf(param) + cls.getCanonicalName() + ", ";
            ++n2;
        }
        String result = String.valueOf(this.returnType.getCanonicalName()) + " " + this.methodName + "(" + param + ")";
        return result;
    }
}

