/*
 * [概要]
 * 
 * =====================================================================================
 * [履歴]
 * 2014-05-09 n.koseki 新規作成
 * 
 * =====================================================================================
 * 
 */
package org.dyndns.nuda.mapper;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.dyndns.nuda.mapper.parser.QUERY_TYPE;

public class SQLContainerImpl implements SQLContainer {
	
	private Map<Integer, String>	queryMap	=
													new HashMap<Integer, String>();
	
	private String					queryId		= "";
	
	private QUERY_TYPE				queryType	= null;
	
	private String					statement	= "";
	
	public SQLContainerImpl(final String queryId, final QUERY_TYPE queryType,
			final String statement) {
		this.queryId = queryId;
		this.queryType = queryType;
		this.statement = statement;
	}
	
	@Override
	public int size() {
		return this.queryMap.size();
	}
	
	@Override
	public boolean isEmpty() {
		return this.queryMap.isEmpty();
	}
	
	@Override
	public boolean containsKey(final Object key) {
		return this.queryMap.containsKey(key);
	}
	
	@Override
	public boolean containsValue(final Object value) {
		return this.queryMap.containsValue(value);
	}
	
	@Override
	public String get(final Object key) {
		return this.queryMap.get(key);
	}
	
	@Override
	public String put(final Integer key, final String value) {
		return this.queryMap.put(key, value);
	}
	
	@Override
	public String remove(final Object key) {
		return this.queryMap.remove(key);
	}
	
	@Override
	public void putAll(final Map<? extends Integer, ? extends String> m) {
		this.queryMap.putAll(m);
	}
	
	@Override
	public void clear() {
		this.queryMap.clear();
	}
	
	@Override
	public Set<Integer> keySet() {
		return this.queryMap.keySet();
	}
	
	@Override
	public Collection<String> values() {
		return this.queryMap.values();
	}
	
	@Override
	public Set<java.util.Map.Entry<Integer, String>> entrySet() {
		return this.queryMap.entrySet();
	}
	
	@Override
	public String getQueryId() {
		return this.queryId;
	}
	
	@Override
	public QUERY_TYPE getQueryType() {
		return this.queryType;
	}
	
	@Override
	public String getStatement() {
		return this.statement;
	}
	
}
