/*
 * [概要]
 * 
 * =====================================================================================
 * [履歴]
 * 2014-05-09 n.koseki 新規作成
 * 
 * =====================================================================================
 * 
 */
package org.dyndns.nuda.mapper.cache;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import org.dyndns.nuda.mapper.SQLInterfaceBean;
import org.dyndns.nuda.mapper.connection.SQLInterfaceConnection;
import org.dyndns.nuda.mapper.connection.SQLInterfacePreparedStatement;

/**
 * 
 * @author nkoseki
 * 
 */
public class EmbedCacheManager implements CacheManager {
	private Map<String, SQLInterfacePreparedStatement>	cache	=
																	new HashMap<String, SQLInterfacePreparedStatement>();
	
	@Override
	public PreparedStatement getStatement(final String sql,
			final SQLInterfaceConnection con,
			final SQLInterfaceBean sqlInterfaceBean) throws SQLException {
		PreparedStatement pstmt = null;
		if (this.cache.containsKey(sql)) {
			pstmt = this.cache.get(sql);
			
			if (pstmt.isClosed()) {
				pstmt = con.prepareStatement(sql);
				this.cache.put(sql, (SQLInterfacePreparedStatement) pstmt);
			}
		} else {
			pstmt = con.prepareStatement(sql);
			((SQLInterfacePreparedStatement) pstmt)
				.setInterfaceBean(sqlInterfaceBean);
			this.cache.put(sql, (SQLInterfacePreparedStatement) pstmt);
		}
		return pstmt;
	}
	
	@Override
	public void init() {
	}

	@Override
	public void deleteCache(String sql) {
		cache.remove(sql);
	}
	
}
