/*
 * [概要]
 * 
 * =====================================================================================
 * [履歴]
 * 2014-05-09 n.koseki 新規作成
 * 
 * =====================================================================================
 * 
 */
package org.dyndns.nuda.mapper.helper;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/**
 * コマンド受領オブジェクト用ヘルパークラスです
 * 
 * @author nkoseki
 * 
 */
public class CommandAcceptorHelper {
	
	/**
	 * 引数に指定されたクラスオブジェクトを生成元としてコマンド受領オブジェクトを生成して返します
	 * 
	 * @param decClass
	 *            コマンド受領オブジェクトの生成元となるクラスオブジェクト
	 * @return コマンド受領オブジェクト
	 */
	public static CommandAcceptor getAcceptor(final Class<?> decClass) {
		
		CommandAcceptor acceptor = new CommandAcceptor() {
			private List<CommandSigniture>	csList			=
																new ArrayList<CommandSigniture>();
			
			private CommandSigniture		cs				= null;
			
			private Class<?>				declaredClass	= null;
			
			@Override
			public boolean accept(final Method method) {
				this.cs = new CommandSigniture(method);
				if (this.declaredClass == null) {
					this.declaredClass = decClass;
				}
				
				if (this.csList.size() == 0) {
					for (Method m : decClass.getDeclaredMethods()) {
						this.csList.add(new CommandSigniture(m));
					}
				}
				
				for (CommandSigniture comCs : this.csList) {
					if (comCs.equals(this.cs)) {
						return true;
					}
				}
				return false;
			}
			
			@Override
			public Class<?> getDeclaredClass() {
				return this.declaredClass;
			}
		};
		
		return acceptor;
	}
}
