/*
 * [概要]
 * 
 * =====================================================================================
 * [履歴]
 * 2014-05-09 n.koseki 新規作成
 * 
 * =====================================================================================
 * 
 */
package org.dyndns.nuda.mapper.helper;

import java.util.ArrayList;
import java.util.List;

import org.dyndns.nuda.mapper.SQLInterfaceBean;

/**
 * 発行されたSQLコマンドと利用されたデータのペアを表すJavaBeansです
 * 
 * @author nkoseki
 * 
 */
public class CommandDataPair {
	private SQLInterfaceBean	sqlInterfaceBean;
	private List<Object>		dataList	= new ArrayList<Object>();
	
	/**
	 * SQLコマンドオブジェクトを取得します
	 * 
	 * @return SQLコマンドオブジェクト
	 */
	public SQLInterfaceBean getSqlInterfaceBean() {
		return this.sqlInterfaceBean;
	}
	
	/**
	 * このインスタンスにSQLコマンドオブジェクトを設定します
	 * 
	 * @param sqlInterfaceBean
	 *            SQLコマンドオブジェクト
	 */
	public void setSqlInterfaceBean(final SQLInterfaceBean sqlInterfaceBean) {
		this.sqlInterfaceBean = sqlInterfaceBean;
	}
	
	/**
	 * 対となるSQLコマンドオブジェクトの発行に用いられたデータを登録します
	 * 
	 * @param param
	 *            SQLコマンドオブジェクトの発行に用いられたデータ
	 */
	public void addData(final Object param) {
		this.dataList.add(param);
	}
	
	/**
	 * 対となるSQLコマンドオブジェクトの発行に用いられたデータを取得します
	 * 
	 * @return SQLコマンドオブジェクトの発行に用いられたデータ
	 */
	public List<Object> getData() {
		return this.dataList;
	}
}
