/*
 * [概要]
 * 
 * =====================================================================================
 * [履歴]
 * 2014-05-09 n.koseki 新規作成
 * 
 * =====================================================================================
 * 
 */
package org.dyndns.nuda.mapper.helper;

import org.dyndns.nuda.mapper.JDBCXMLInvocationHandler;
import org.dyndns.nuda.plugin.Plugable;

/**
 * SQLInterfaceコンテナを制御するためのコマンドを表すインタフェースです
 * 
 * @author nkoseki
 * 
 */
public interface SQLInterfaceControllerCommand extends Plugable {
	
	/**
	 * このインスタンスにSQLInterfaceコンテナを設定します
	 * 
	 * @param container
	 *            SQLInterfaceコンテナ
	 */
	public void setContainer(JDBCXMLInvocationHandler container);
	
	/**
	 * このインスタンスに設定されているSQLInterfaceコンテナを取得します
	 * 
	 * @return SQLInterfaceコンテナ
	 */
	public JDBCXMLInvocationHandler getContainer();
}
