package org.dyndns.nuda.mapper.parameter;

import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.dyndns.nuda.mapper.SQLMapperException;

public class BigIntegerSQLParameter implements SQLParameter {
	
	@Override
	public boolean accept(final Class<?> parameterType) {
		return parameterType == BigInteger.class;
	}
	
	@Override
	public void setParameter(final PreparedStatement pstmt, final int index,
			final Object parameter, final Class<?> parameterType)
			throws SQLException {
		throw new SQLMapperException("unsupported type BigInteger");
	}
	
}
