package org.dyndns.nuda.mapper.parameter;

import java.sql.PreparedStatement;
import java.sql.SQLException;

public class IntSQLParameter implements SQLParameter {
	
	@Override
	public boolean accept(final Class<?> parameterType) {
		return parameterType == int.class;
	}
	
	@Override
	public void setParameter(final PreparedStatement pstmt, final int index,
			final Object parameter, final Class<?> parameterType)
			throws SQLException {
		pstmt.setInt(index, Integer.class.cast(parameter));
	}
	
}
