package org.dyndns.nuda.mapper.parameter;

import java.sql.PreparedStatement;
import java.sql.SQLException;

public class JavaUtilDateSQLParameter implements SQLParameter {
	
	@Override
	public boolean accept(final Class<?> parameterType) {
		return parameterType == java.util.Date.class;
	}
	
	@Override
	public void setParameter(final PreparedStatement pstmt, final int index,
			final Object parameter, final Class<?> parameterType)
			throws SQLException {
		java.util.Date d = java.util.Date.class.cast(parameter);
		
		pstmt.setDate(index, new java.sql.Date(d.getTime()));
	}
	
}
