package org.dyndns.nuda.mapper.parameter;

import java.sql.PreparedStatement;
import java.sql.SQLException;

public class LongSQLParameter implements SQLParameter {
	
	@Override
	public boolean accept(final Class<?> parameterType) {
		return parameterType == long.class;
	}
	
	@Override
	public void setParameter(final PreparedStatement pstmt, final int index,
			final Object parameter, final Class<?> parameterType)
			throws SQLException {
		pstmt.setLong(index, Long.class.cast(parameter));
	}
	
}
